<?php
if(!defined('_PS_VERSION_'))
	exit;
	
class verifonepayment extends PaymentModule{
	
	private $_html = '';
	private $INVOICE_FEE_LIMIT = 48;

	public function __construct(){
		$this->name = 'verifonepayment';
        $this->tab = 'payments_gateways';
		$this->version = 2.0;
		$this->author = 'Open Mind';
		$this->need_instance = 0;
 
        parent::__construct(); // The parent construct is required for translations

        $this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Verifone payment');
		$this->description = $this->l('Receive cardpayments');
	}

	public static function getPageLink($str, $ssl){
		$link = new Link();
		return $link->getPageLink($str, $ssl);
	}

	public static function getCurrencyFromOrder($id_order){
		$db = Db::getInstance();
		$query = "SELECT `id_currency` FROM `"._DB_PREFIX_."orders` WHERE `id_order` = '".$id_order."';";
		$result = $db->ExecuteS($query);
		$id_currency;
		foreach ($result as $row) {
		  $id_currency=$row["id_currency"];
		}

		$query = "SELECT `sign` FROM `"._DB_PREFIX_."currency` WHERE `id_currency` = '".$id_currency."';";
		$result = $db->ExecuteS($query);
		$sign;
		foreach ($result as $row) {
		  $sign = $row["sign"];
		}

		return $sign;
	}

	public function getSettings(){

		if(Configuration::get($this->name.'card_title') != false){
			$card_title = Configuration::get($this->name.'card_title');
		}else{
			$card_title = "";
		}
		
		$card_enabled = Configuration::get($this->name.'card_enabled');

		if(Configuration::get($this->name.'electronic_title') != false){
			$electronic_title = Configuration::get($this->name.'electronic_title');
		}else{
			$electronic_title = "";
		}
		
		$electronic_enabled = Configuration::get($this->name.'electronic_enabled');
		
		if(Configuration::get($this->name.'invoice_title') != false){
			$invoice_title = Configuration::get($this->name.'invoice_title');
		}else{
			$invoice_title = "";
		}
		
		$invoice_enabled = Configuration::get($this->name.'invoice_enabled');
		
		if(Configuration::get($this->name.'merccode') != false){
			$merccode = Configuration::get($this->name.'merccode');
		}else{
			$merccode = "";
		}
		
		if(Configuration::get($this->name.'privkey') != false){
			$privkey = Configuration::get($this->name.'privkey');
		}else{
			$privkey = "";
		}
		
		if (Configuration::get($this->name.'pubkey') != false){
			$pubkey = Configuration::get($this->name.'pubkey');
		}else{
			$pubkey = "";
		}

		if (Configuration::get($this->name.'purl1') != false){
			$purl1 = Configuration::get($this->name.'purl1');
		}else{
			$purl1 = "";
		}
		
		if (Configuration::get($this->name.'purl2') != false){
			$purl2 = Configuration::get($this->name.'purl2');
		}else{
			$purl2 = "";
		}

		if (Configuration::get($this->name.'purl3') != false){
			$purl3 = Configuration::get($this->name.'purl3');
		}else{
			$purl3 = "";
		}

		if (Configuration::get($this->name.'languagecode') != false){
			$languagecode = Configuration::get($this->name.'languagecode');
		}else{
			$languagecode = "";
		}

		$chkavail = Configuration::get($this->name.'chkavail');
		$skipconfirm = Configuration::get($this->name.'skipconfirm');

		$verifone_set = array(
			'card_title' => $card_title,
			'card_enabled' => $card_enabled,
			'electronic_title' => $electronic_title,
			'electronic_enabled' => $electronic_enabled,
			'invoice_title' => $invoice_title,
			'invoice_enabled' => $invoice_enabled,
			'merccode' => $merccode,
			'privkey' => $privkey,
			'pubkey' => $pubkey,
			'purl1' => $purl1,
			'purl2' => $purl2,
			'purl3' => $purl3,
			'languagecode' => $languagecode,
			'chkavail' => $chkavail,
			'skipconfirm' => $skipconfirm
		);
		return $verifone_set;
	}
	
	/*
	 -on submit, writing config to db and reloading the form
	*/
	public function getContent()
	{
	  if (Tools::isSubmit('submit'))
	  {
		Configuration::updateValue($this->name.'card_title', Tools::getValue('verifone_card_title'));
		Configuration::updateValue($this->name.'card_enabled', Tools::getValue('verifone_card_enabled'));
		Configuration::updateValue($this->name.'electronic_title', Tools::getValue('verifone_electronic_title'));
		Configuration::updateValue($this->name.'electronic_enabled', Tools::getValue('verifone_electronic_enabled'));
		Configuration::updateValue($this->name.'invoice_title', Tools::getValue('verifone_invoice_title'));
		Configuration::updateValue($this->name.'invoice_enabled', Tools::getValue('verifone_invoice_enabled'));
		Configuration::updateValue($this->name.'merccode', Tools::getValue('verifone_merccode'));
		Configuration::updateValue($this->name.'privkey', Tools::getValue('verifone_privkey'));
		Configuration::updateValue($this->name.'pubkey', Tools::getValue('verifone_pubkey'));
		Configuration::updateValue($this->name.'purl1', Tools::getValue('verifone_purl1'));
		Configuration::updateValue($this->name.'purl2', Tools::getValue('verifone_purl2'));
		Configuration::updateValue($this->name.'purl3', Tools::getValue('verifone_purl3'));
		Configuration::updateValue($this->name.'languagecode', Tools::getValue('verifone_languagecode'));
		Configuration::updateValue($this->name.'chkavail', Tools::getValue('verifone_chkavail'));
		Configuration::updateValue($this->name.'skipconfirm', Tools::getValue('verifone_skipconfirm'));
	  }
	  $this->_displayForm();
	  return $this->_html;
	}	
	
	/*
		Configuration form for the administrator of the BackOffice
	*/
	private function _displayForm()
	{
		$verifone_settings = $this->getSettings();

		$card_title = $verifone_settings['card_title'];
		$card_enabled = $verifone_settings['card_enabled'];
		$electronic_title = $verifone_settings['electronic_title'];
		$electronic_enabled = $verifone_settings['electronic_enabled'];
		$invoice_title = $verifone_settings['invoice_title'];
		$invoice_enabled = $verifone_settings['invoice_enabled'];
		$merccode = $verifone_settings['merccode'];
		$privkey = $verifone_settings['privkey'];
		$pubkey = $verifone_settings['pubkey'];
		$purl1 = $verifone_settings['purl1'];
		$purl2 = $verifone_settings['purl2'];
		$purl3 = $verifone_settings['purl3'];
		$chkavail = $verifone_settings['chkavail'];
		$skipconfirm = $verifone_settings['skipconfirm'];
		$languagecode = $verifone_settings['languagecode'];

		$css_width_textbox = '250';

	  	$this->_html .= '
		<div style="width:500px;margin:auto;">
			<fieldset>
			<legend>'.$this->l('Verifone Payment Configuration').'</legend>
			<center><img src="'.__PS_BASE_URI__.'modules/verifonepayment/logo.png" style="width:150px;"/></center>
			<div>
				<p>
					Check pending Verifone payments and update order status if they have been verified. You can paste the following
					URL in the crontab, or manually update by clicking the link below.
				</p>
				<a href="javascript:updateVerifoneOrders()">' . Tools::getShopDomainSsl(true) . __PS_BASE_URI__ . "modules/verifonepayment/verifone_cron.php" . '</a>
			</div>
			<script type="text/javascript">
				function updateVerifoneOrders() {
					var url = "' . __PS_BASE_URI__ . "modules/verifonepayment/verifone_cron.php" . '";
    				xmlhttp=new XMLHttpRequest();
					xmlhttp.open("GET", url + "?t=" + Math.random(),true);
					xmlhttp.send();
					alert("Checking pending orders");
				}
			</script>
			<br />
			<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<table border="0">
				<tr>
					<td>'.$this->l('Credit Card Title').'</td>
					<td><input type="text" name="verifone_card_title" value="'.$card_title.'" style="width:'.$css_width_textbox.'px;"></td>
				</tr>
				<tr>
					<td>'.$this->l('Credit Card Enabled').'</td>
					<td>
						<select name="verifone_card_enabled">';
							if($card_enabled=="true"){
								$this->_html .= '<option value="true" selected="selected">Yes</option>
								 	  <option value="false">'.$this->l('No').'</option>';
							}else{
								$this->_html .= '<option value="true">'.$this->l('Yes').'</option>
								  	  <option value="false" selected="selected">No</option>';
							}
						$this->_html .= '
						</select>
					</td>
				</tr>
				<tr>
					<td>'.$this->l('Direct Title').'</td>
					<td><input type="text" name="verifone_electronic_title" value="'.$electronic_title.'" style="width:'.$css_width_textbox.'px;"></td>
				</tr>
				<tr>
					<td>'.$this->l('Direct Enabled').'</td>
					<td>
						<select name="verifone_electronic_enabled">';
							if($electronic_enabled=="true"){
								$this->_html .= '<option value="true" selected="selected">Yes</option>
								 	  <option value="false">'.$this->l('No').'</option>';
							}else{
								$this->_html .= '<option value="true">'.$this->l('Yes').'</option>
								  	  <option value="false" selected="selected">No</option>';
							}
						$this->_html .= '
						</select>
					</td>
				</tr>
				<tr>
					<td>'.$this->l('Invoice Title').'</td>
					<td><input type="text" name="verifone_invoice_title" value="'.$invoice_title.'" style="width:'.$css_width_textbox.'px;"></td>
				</tr>
				<tr>
					<td>'.$this->l('Invoice Enabled').'</td>
					<td>
						<select name="verifone_invoice_enabled">';
							if($invoice_enabled=="true"){
								$this->_html .= '<option value="true" selected="selected">Yes</option>
								 	  <option value="false">'.$this->l('No').'</option>';
							}else{
								$this->_html .= '<option value="true">'.$this->l('Yes').'</option>
								  	  <option value="false" selected="selected">No</option>';
							}
						$this->_html .= '
						</select>
					</td>
				</tr>
				<tr>
					<td>'.$this->l('Verifone Payment merchant agreement code').'</td>
					<td><input type="text" name="verifone_merccode" id="verifone_merccode" style="width:'.$css_width_textbox.'px;" value="'.$merccode.'"></td>
				</tr>
				<tr>
					<td>'.$this->l('Shop private key filename').'</td>
					<td><input type="text" name="verifone_privkey" style="width:'.$css_width_textbox.'px;" value="'.$privkey.'"></td>
				</tr>
				<tr>
					<td>'.$this->l('Verifone public key filename').'</td>
					<td><input type="text" name="verifone_pubkey" style="width:'.$css_width_textbox.'px;" value="'.$pubkey.'"></td>
				</tr>
				<tr>
					<td>'.$this->l('Pay page URL 1').'</td>
					<td><input type="text" name="verifone_purl1" style="width:'.$css_width_textbox.'px;" value="'.$purl1.'"></td>
				</tr>
				<tr>
					<td>'.$this->l('Pay page URL 2').'</td>
					<td><input type="text" name="verifone_purl2" style="width:'.$css_width_textbox.'px;" value="'.$purl2.'"></td>
				</tr>
				<tr>
					<td>'.$this->l('Pay page URL 3').'</td>
					<td><input type="text" name="verifone_purl3" style="width:'.$css_width_textbox.'px;" value="'.$purl3.'"></td>
				</tr>
				<tr>
					<td>'.$this->l('Language').'</td>
					<td>
						<select name="verifone_languagecode">';
						$languages = array(
							'da_DK' => 'Danish',
							'nl_NL' => 'Dutch',
							'en_GB' => 'English',
							'fi_FI' => 'Finnish',
							'fr_FR' => 'French',
							'de_DE' => 'German',
							'no_NO' => 'Norwegian',
							'sv_SE' => 'Swedish',
							'sv_FI' => 'Swedish (Finnish)');
						foreach($languages as $key => $value)
						{
							$this->_html .= '<option value="'.$key. ($languagecode == $key ? '" selected="selected">' : '">') .$value.'</option>';
						}
						$this->_html .= '</select>
				</tr>
				<tr>
					<td>'.$this->l('Check payment node availability').'</td>
					<td>
						<select name="verifone_chkavail">
						  ';
							if($chkavail=="true"){
								$this->_html .= '<option value="true" selected="selected">'.$this->l('Yes').'</option>
								 	  <option value="false">'.$this->l('No').'</option>';
							}else{
								$this->_html .= '<option value="true">'.$this->l('Yes').'</option>
								  	  <option value="false" selected="selected">'.$this->l('No').'</option>';
							}
						$this->_html .= '
						</select>
					</td>
				</tr>
				<tr>
					<td>'.$this->l('Skip confirmation page').'</td>
					<td>
						<select name="verifone_skipconfirm">
						  ';
							if($skipconfirm=="true"){
								$this->_html .= '<option value="true" selected="selected">'.$this->l('Yes').'</option>
								 	  <option value="false">'.$this->l('No').'</option>';
							}else{
								$this->_html .= '<option value="true">'.$this->l('Yes').'</option>
								  	  <option value="false" selected="selected">'.$this->l('No').'</option>';
							}
						$this->_html .= '
						</select>
					</td>
				</tr>
			</table>

			<input type="submit" name="submit" class="button" value="UPDATE">
			</form>
			</fieldset>
		</div>
	  ';
	}
	
	/*
	This is the HTML that shall be presented on the FrontOffice to the user
	*/
	function hookPayment($params)
	{
		$verifone_card_title = Configuration::get($this->name.'card_title');
		$verifone_card_enabled = Configuration::get($this->name.'card_enabled');
		$verifone_electronic_title = Configuration::get($this->name.'electronic_title');
		$verifone_electronic_enabled = Configuration::get($this->name.'electronic_enabled');
		$verifone_invoice_title = Configuration::get($this->name.'invoice_title');
		$verifone_invoice_enabled = Configuration::get($this->name.'invoice_enabled');
				
		global $smarty;
		$smarty->assign(array(
			'verifone_card_title' => $verifone_card_title,
			'verifone_card_enabled' => $verifone_card_enabled,
			'verifone_electronic_title' => $verifone_electronic_title,
			'verifone_electronic_enabled' => $verifone_electronic_enabled,
			'verifone_invoice_title' => $verifone_invoice_title,
			'verifone_invoice_enabled' => $verifone_invoice_enabled,
			'this_path' => $this->_path,
			'this_path_ssl' => Configuration::get('PS_FO_PROTOCOL').$_SERVER['HTTP_HOST'].__PS_BASE_URI__."modules/{$this->name}/"));
		 
		return $this->display(__FILE__, 'payment.tpl');
	}
	
	/*
		Installation settings and registration of hook for the frontoffice
	*/
	public function install()
	{
		if (!parent::install()
			OR !$this->registerHook('invoice')
			OR !$this->registerHook('payment')
			OR !$this->registerHook('paymentReturn'))
			return false;
		
		Configuration::updateValue($this->name.'card_enabled', "true");
		Configuration::updateValue($this->name.'card_title', "Kortbetalning");
		
		Configuration::updateValue($this->name.'electronic_enabled', "true");
		Configuration::updateValue($this->name.'electronic_title', "Direktbetalning");
		
		Configuration::updateValue($this->name.'invoice_enabled', "true");
		Configuration::updateValue($this->name.'invoice_title', "Faktura");
		
		Configuration::updateValue($this->name.'merccode', "");
		Configuration::updateValue($this->name.'privkey', "");
		Configuration::updateValue($this->name.'pubkey', "");
		Configuration::updateValue($this->name.'purl1', "https://epayment1.point.fi/pw/payment");
		Configuration::updateValue($this->name.'purl2', "https://epayment2.point.fi/pw/payment");
		Configuration::updateValue($this->name.'purl3', "https://epayment3.point.fi/pw/payment");
		Configuration::updateValue($this->name.'languagecode', "en_GB");
		Configuration::updateValue($this->name.'chkavail', "false");
		Configuration::updateValue($this->name.'skipconfirm', "false");
		
		return true;
	}

	function getOrderFromDatabase($order_number){
		$db = Db::getInstance();
		$sql = "SELECT * FROM `"._DB_PREFIX_."verifone_orders` WHERE `id` = " . $order_number;
	
		$result = $db->ExecuteS($sql);
	
		$resPos = sizeof($result) -1;
		$res = $result[$resPos];
		return $res;
	}
	
	public function validateInputs($posts, $transaction_id, $order_amount, $sign_one, $sign_two, $merccode, $order_number){
		//Controll all the inputs for values
		if($transaction_id && $order_amount && $sign_one && $sign_two && ($merccode || true) && $order_number){
			//Control that the merchant agreement code matches
			$internal_merccode = Configuration::get('verifonepaymentmerccode');
			if($internal_merccode == $merccode || true){
				//Control the signature
				unset($posts["s-t-1-40_shop-receipt__phase"]);
				$signedformdata = $posts;
				unset($signedformdata["s-t-256-256_signature-one"]);
				unset($signedformdata["s-t-256-256_signature-two"]);
	
				$cryptutils = new Verifone_VerifonePayment_Helper_Cryptutils;
				$signature_valid = $cryptutils->verifysignature($cryptutils->formatparameters($signedformdata), $posts["s-t-256-256_signature-one"]);
				if($signature_valid){
					//Check orderID
					$order = $this->getOrderFromDatabase($order_number);
					if(isset($order)){
						//Check order amount
						if($order['amount'] == $order_amount){
							return true;
						}else{
							error_log("Error validating paymentresponse, invalid order amount. Received : ".$order_amount.", found :".$order['amount']);
						}
					}else{
						error_log("Error validating paymentresponse, invalid ordernumber, returned : " . $order);
						return false;
					}
				}else{
					error_log("Error validating paymentresponse, invalid signature");
					return false;
				}
			}else{
				error_log("Error validating paymentresponse, invalid merccode");
				return false;
			}
		}else{
			error_log("Error validating paymentresponse, missing params");
			return false;
		}
	}
	
	public function saveOrder($ordernumber, $order_total, $transaction_id, $secure_key){
		$cart = new Cart($ordernumber);
		if($cart->OrderExists() == false) {
			$orderstatus = Configuration::get('PS_OS_PAYMENT');
			$this->validateOrder($ordernumber, $orderstatus, floatval($order_total / 100), "Verifone payment", "Verifone transaction ID : ".$transaction_id, null , null, null , $secure_key, null);
		}
	}
	
	/*
	* This function will display the card details form payment_execution.tpl
	* It will check if the submit button on the form has been pressed and submit the card details to the database 
	*/
	public function execPayment($cart)
	{
		if (!$this->active)
			return;
		 
		global $cookie, $smarty;
		 
		$smarty->assign(array(
			'this_path' => $this->_path,
			'this_path_ssl' => (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/'.$this->name.'/'
		));
		 
		return $this->display(__FILE__, 'payment_execution.tpl');
	}
	
	function get_verifone_server_to_server_args($operation) {
		$request_id = rand();
		$request_timestamp = gmdate("Y-m-d H:i:s");
	
		$fields = array();
		$fields['s-f-1-30_operation'] = $operation;
		$fields['l-f-1-20_request-id'] = $request_id;
		$fields['t-f-14-19_request-timestamp'] = $request_timestamp;
		$fields['s-f-1-36_merchant-agreement-code'] = Configuration::get('verifonepaymentmerccode');
		$fields['s-f-1-30_software'] = "Prestashop";
		$fields['s-f-1-10_software-version'] = _PS_VERSION_;
		$fields['i-f-1-11_interface-version'] = '5';
	
		return $fields;
	}
	
	function post_fields($server, $fields) {
		$cryptutils = new Verifone_VerifonePayment_Helper_Cryptutils;
		$formatted_data = $cryptutils->formatparameters($fields);
		$fields["s-t-256-256_signature-one"] = $cryptutils->generatesignature($formatted_data);
			
		$options = array(
				'http' => array(
						'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
						'method'  => 'POST',
						'content' => http_build_query($fields)));
	
		$context = stream_context_create($options);
		$result = file_get_contents($server, false, $context);
		
		parse_str($result, $output);
		return $output;
	}
	
	function verify_response($fields, $result) {
		if($fields['s-f-1-30_operation'] != $result['s-f-1-30_operation'] ||
			isset($fields['s-f-1-30_error-message']) ||
			$fields['l-f-1-20_request-id'] != $result['l-f-1-20_request-id']) {
				return false;
		}
					
		$signedformdata = $result;
		unset($signedformdata["s-t-256-256_signature-one"]);
		unset($signedformdata["s-t-256-256_signature-two"]);
		$cryptutils = new Verifone_VerifonePayment_Helper_Cryptutils;
		$signature_valid = $cryptutils->verifysignature($cryptutils->formatparameters($signedformdata), $result["s-t-256-256_signature-one"]);
		return $signature_valid;
	}
	
	function get_payment_status($server, $transaction_id, $payment_method, $order_id, $order_total) {
		$fields = $this->get_verifone_server_to_server_args('get-payment-status');
		$fields['s-f-1-30_payment-method-code'] = $payment_method;
		$fields['l-f-1-20_transaction-number'] = $transaction_id;
	
		$result = $this->post_fields($server, $fields);
			
		if(!$this->verify_response($fields, $result)) {
			error_log("VERIFONE, bad response");
			return;
		}
			
		if($result['l-f-1-20_transaction-number'] == $transaction_id &&
				$result['s-f-1-30_payment-method-code'] == $payment_method &&
				$result['s-f-1-36_order-number'] = $order_id)
		{
			if($result['l-f-1-20_order-gross-amount'] == $order_total &&
				$result['s-f-1-30_payment-status-code'] == 'verified') {
				$this->saveOrder($order_id, $order_total, $transaction_id, false);
				return true;
			}
		}
			
		return false;
	}
	
	function list_transaction_numbers($order_id, $order_total, $server) {
		$fields = $this->get_verifone_server_to_server_args('list-transaction-numbers');
		$fields['s-f-1-36_order-number'] = $order_id;
		
		$result = $this->post_fields($server, $fields);
		
		if(!$this->verify_response($fields, $result)) {
			error_log("VERIFONE, bad response");
			return false;
		}
			
		for($i = 1;; $i++) {
			if(!isset($result['l-f-1-20_transaction-number-'.$i])) {
				break;
			}
	
			$transaction_id = $result['l-f-1-20_transaction-number-'.$i];
			$payment_method = $result['s-f-1-30_payment-method-code-'.$i];
	
			if($this->get_payment_status($server, $transaction_id, $payment_method, $order_id, $order_total)) {
				return true;
			}
		}
			
		return false;
	}
	
	public function checkPayment()
	{
		$sql = 
			'SELECT vo.* FROM '._DB_PREFIX_.'verifone_orders vo '.
			'LEFT JOIN '._DB_PREFIX_.'orders o ON vo.id = o.id_cart '.
			'LEFT JOIN '._DB_PREFIX_.'cart c ON vo.id = c.id_cart '.
			'WHERE o.id_order IS NULL';
		
		$orders = Db::getInstance()->ExecuteS($sql);
		
		foreach($orders as $order)
		{
			$order_id = $order['id'];
			$order_total = $order['amount'];
			$server = $order['server'];
			
			$server = preg_replace("/\bpayment$/", "serverinterface", $server);
			
			$this->list_transaction_numbers($order_id, $order_total, $server);
		}
		
		Db::getInstance()->delete('verifone_orders', 'ts < DATE_SUB(NOW(), INTERVAL 1 DAY)');
	}
}
?>