<?php
include(dirname(__FILE__).'/../../config/config.inc.php');
include(dirname(__FILE__).'/../../init.php');
$context = Context::getContext();
$fc = new Frontcontroller();
$fc->setmedia();
include(dirname(__FILE__).'/../../header.php');
include(dirname(__FILE__).'/verifonepayment.php');

$module = new verifonepayment();

$reason = $_POST['s-t-1-30_cancel-reason'];

if($reason === 'cancel-user-canceled'){
	echo getCancelledPage($module);
}else if($reason === 'cancel-reason-user-canceled'){
	echo getCancelledPage($module);
}else if($reason === 'cancel-payment-rejected'){
	echo getRejectedPage($module);
}else if($reason === 'cancel-payment-expired'){
	echo getExpiredPage($module);
}else /*if($reason === 'cancel-system-error')*/{
	echo getTechnicalErrorPage($module);
}

include(dirname(__FILE__).'/../../footer.php');



function getTechnicalErrorPage($module){
	$_html = '
		<html>
		<head>
			<title>'.$module->l('Technical Error').'</title>
			<link rel="stylesheet" type="text/css" href="'.__PS_BASE_URI__.'modules/verifonepayment/verifonestyle.css" />
			<script>
				function goBack()
				  {
				  window.history.back();
				  }
			</script>
		</head>
		<body>
		<div id="container">
			<div class="verifonemodule">
				<img src="'.__PS_BASE_URI__.'modules/verifonepayment/logo.png" style="width:150px;" alt="Verifone" class="verifone-logo"/>
				<h1>'.$module->l('Payment failed').'</h1>
				<div class="verifone-messages">
					<p>'.$module->l('Technical Error').'</p>
					<p>'.$module->l('An error occurred while processing your payment.').'</p>
					<p>'.$module->l('Please try again or choose another payment option').'.</p>
				</div>
				<div class="verifone-buttonrow">
					<a href="'.verifonepayment::getPageLink('order.php', false).'?step=3'.'"><button type="button" class="verifone-button verifone-back" >'.$module->l('Back to payment options').'</button></a>
				</div>
			</div>
		</div>
		</body>
		</html>
	';

	return $_html;
}

function getCancelledPage($module){
	$_html = '
		<html>
		<head>
			<title>'.$module->l('Cancelled').'</title>
			<link rel="stylesheet" type="text/css" href="'.__PS_BASE_URI__.'modules/verifonepayment/verifonestyle.css" />
			<script>
				function goBack()
				  {
				  window.history.back();
				  }
			</script>
		</head>
		<body>
		<div id="container">
			<div class="verifonemodule">
				<img src="'.__PS_BASE_URI__.'modules/verifonepayment/logo.png" style="width:150px;" alt="Verifone" class="verifone-logo"/>
				<h1>'.$module->l('Payment failed').'</h1>
				<div class="verifone-messages">
					<p>'.$module->l('An error occurred while processing your payment.').'</p>
					<p>'.$module->l('Your purchase was cancelled').'.</p>
					<p>'.$module->l('Please try again or choose another paymentoption').'.</p>
				</div>
				<div class="verifone-buttonrow">
					<a href="'.verifonepayment::getPageLink('order.php', false).'?step=3'.'"><button type="button" class="verifone-button verifone-back" >'.$module->l('Back to payment options').'</button></a>
				</div>
			</div>
		</div>
		</body>
		</html>
	';

	return $_html;
}

function getErrorPage($module){
	$_html = '
		<html>
		<head>
			<title>'.$module->l('Error').'</title>
			<link rel="stylesheet" type="text/css" href="'.__PS_BASE_URI__.'modules/verifonepayment/verifonestyle.css" />
			<script>
				function goBack()
				  {
				  window.history.back();
				  }
			</script>
		</head>
		<body>
		<div id="container">
			<div class="verifonemodule">
				<img src="'.__PS_BASE_URI__.'modules/verifonepayment/logo.png" style="width:150px;" alt="Verifone" class="verifone-logo"/>
				<h1>'.$module->l('Payment failed').'</h1>
				<div class="verifone-messages">
					<p>'.$module->l('An error occurred while processing your payment. Please try again or select another paymentoption').'.</p>
				</div>
				<div class="verifone-buttonrow">
					<a href="'.verifonepayment::getPageLink('order.php', false).'?step=3'.'"><button type="button" class="verifone-button verifone-back" >'.$module->l('Back to payment options').'</button></a>
				</div>
			</div>
		</div>
		</body>
		</html>
	';

	return $_html;
}

function getExpiredPage($module){
	$_html = '
		<html>
		<head>
			<title>'.$module->l('Error').'</title>
			<link rel="stylesheet" type="text/css" href="'.__PS_BASE_URI__.'modules/verifonepayment/verifonestyle.css" />
			<script>
				function goBack()
				  {
				  window.history.back();
				  }
			</script>
		</head>
		<body>
		<div id="container">
			<div class="verifonemodule">
				<img src="'.__PS_BASE_URI__.'modules/verifonepayment/logo.png" style="width:150px;" alt="Verifone" class="verifone-logo"/>
				<h1>'.$module->l('Payment failed').'</h1>
				<div class="verifone-messages">
					<p>'.$module->l('Your session has expired. Please try again or select another paymentoption').'.</p>
				</div>
				<div class="verifone-buttonrow">
					<a href="'.verifonepayment::getPageLink('order.php', false).'?step=3'.'"><button type="button" class="verifone-button verifone-back" >'.$module->l('Back to payment options').'</button></a>
				</div>
			</div>
		</div>
		</body>
		</html>
	';

	return $_html;
}
function getRejectedPage($module){
	$_html = '
		<html>
		<head>
			<title>'.$module->l('Error').'</title>
			<link rel="stylesheet" type="text/css" href="'.__PS_BASE_URI__.'modules/verifonepayment/verifonestyle.css"/>
			<script>
				function goBack()
				  {
				  window.history.back();
				  }
			</script>
		</head>
		<body>
		<div id="container">
			<div class="verifonemodule">
				<img src="'.__PS_BASE_URI__.'modules/verifonepayment/logo.png" alt="Verifone" style="width:150px;" class="verifone-logo"/>
				<h1>'.$module->l('Payment failed').'</h1>
				<div class="verifone-messages">
					<p>'.$module->l('Your payment was rejected by your provider. Please try again or try another paymentoption').'.</p>
				</div>
				<div class="verifone-buttonrow">
					<a href="'.verifonepayment::getPageLink('order.php', false).'?step=3'.'"><button type="button" class="verifone-button verifone-back" >'.$module->l('Back to payment options').'</button></a>
				</div>
			</div>
		</div>
		</body>
		</html>
	';

	return $_html;
}
?>