<?php
include(dirname(__FILE__).'/../../config/config.inc.php');
include(dirname(__FILE__).'/../../init.php');
ob_start();
$context = Context::getContext();
$fc = new Frontcontroller();
$fc->setmedia();
include(dirname(__FILE__).'/../../header.php');
$output = ob_get_contents();
ob_end_clean();
include(dirname(__FILE__).'/Helper/Cryptutils.php');
include(dirname(__FILE__).'/verifonepayment.php');

$ptransaction_id = $_POST['l-f-1-20_transaction-number'];
$porder_amount = $_POST['l-f-1-20_order-gross-amount'];
$psign_one = $_POST['s-t-256-256_signature-one'];
$psign_two = $_POST['s-t-256-256_signature-two'];
$pmerccode = isset($_POST['s-f-1-36_merchant-agreement-code']) ? $_POST['s-f-1-36_merchant-agreement-code'] : '';
$porder_number = $_POST['s-f-1-36_order-number'];

$module = new verifonepayment();

$validInputs = $module->validateInputs($_POST, $ptransaction_id, $porder_amount, $psign_one, $psign_two, $pmerccode, $porder_number);

if($validInputs){
	$module->saveOrder($porder_number, $porder_amount, $ptransaction_id, $cart->secure_key);
	echo $output;
	echo getSuccessPage($module, $porder_number, floatval($porder_amount/100));
}else{
	echo $output;
	echo getErrorPage($module);
}

function getSuccessPage($module, $cart_id, $order_sum){
	
	$order_id = Order::getOrderByCartId(intval($cart_id));
	$currency_sign = verifonepayment::getCurrencyFromOrder($order_id);

	$verifone_html = '
		<style>
			#container{
				width: 85%;
			}
			.verifonemodule{
				border: 1px solid #D9D9D9;
				border-radius: 4px;

				width: 100%;
				font-family: Arial, sans-serif;
				color: #6D6E71;
				padding: 20px 40px;
				font-size: 14px;
			}
			.verifonemodule h1{
				font-size: 30px;
				border-bottom: 4px solid #ed1d24;
				clear: both;
			}
			.verifonemodule .verifone-logo{
				float: right;
				width: 150px;
			}
			.verifonemodule .verifone-messages{
				min-height: 180px;
			}
			.verifonemodule .verifone-buttonrow{
				margin-top: 20px;
				overflow: auto;
			}
			.verifonemodule .verifone-button{
				background: #fafafa;
				color: #6d6f71;
				-webkit-border-radius: 5px;
				-moz-border-radius: 5px;
				border-radius: 5px;
				border: 1px solid #d9d9d9;
				padding: 5px 17px;
				cursor: verifoneer;

				background: -moz-linear-gradient(top, #ffffff 0%, #fafafa 15%);
				background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffffff), color-stop(15%,#fafafa));
				background: -webkit-linear-gradient(top, #ffffff 0%,#fafafa 15%);
				background: -o-linear-gradient(top, #ffffff 0%,#fafafa 15%);
				background: -ms-linear-gradient(top, #ffffff 0%,#fafafa 15%);
				background: linear-gradient(top, #ffffff 0%,#fafafa 15%);
			}
			.verifonemodule .verifone-confirm{
				float: right;
			}
			.verifonemodule .verifone-back{
				float: left;
			}
		</style>
		<script>
			function goBack()
			{
			  window.history.back();
			}
		</script>
		<div id="container">
			<div class="verifonemodule">
				<img src="'.__PS_BASE_URI__.'modules/verifonepayment/logo.png" alt="Verifone" style="width:150px;" class="verifone-logo"/>
				<h1>'.$module->l('Payment successful').'</h1>
				<div class="verifone-messages">
					<p>'.$module->l('Your order has now been placed.').'</p>
					<p>'.$module->l('Your order nr: ').''.$order_id.'.</p>
					<p>'.$module->l('Order sum: ').''.$order_sum.''.$currency_sign.'</p>
				</div>
				<div class="verifone-buttonrow">
					<form action="/../../'.__PS_BASE_URI__.'index.php"><button type="submit" class="verifone-button verifone-confirm">'.$module->l('Continue shopping').'</button></form>
				</div>
			</div>
		</div>
	';
	return $verifone_html;
}

function getErrorPage($module){
	$_html = '
		<style>
			#container{
				width: 85%;
			}
			.verifonemodule{
				border: 1px solid #D9D9D9;
				border-radius: 4px;

				width: 100%;
				font-family: Arial, sans-serif;
				color: #6D6E71;
				padding: 20px 40px;
				font-size: 14px;
			}
			.verifonemodule h1{
				font-size: 30px;
				border-bottom: 4px solid #ed1d24;
				clear: both;
			}
			.verifonemodule .verifone-logo{
				float: right;
			}
			.verifonemodule .verifone-messages{
				min-height: 180px;
			}
			.verifonemodule .verifone-buttonrow{
				margin-top: 20px;
				overflow: auto;
			}
			.verifonemodule .verifone-button{
				background: #fafafa;
				color: #6d6f71;
				-webkit-border-radius: 5px;
				-moz-border-radius: 5px;
				border-radius: 5px;
				border: 1px solid #d9d9d9;
				padding: 5px 17px;
				cursor: verifoneer;

				background: -moz-linear-gradient(top, #ffffff 0%, #fafafa 15%);
				background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffffff), color-stop(15%,#fafafa));
				background: -webkit-linear-gradient(top, #ffffff 0%,#fafafa 15%);
				background: -o-linear-gradient(top, #ffffff 0%,#fafafa 15%);
				background: -ms-linear-gradient(top, #ffffff 0%,#fafafa 15%);
				background: linear-gradient(top, #ffffff 0%,#fafafa 15%);
			}
			.verifonemodule .verifone-confirm{
				float: right;
			}
			.verifonemodule .verifone-back{
				float: left;
			}
		</style>
		<div id="container">
			<div class="verifonemodule">
				<img src="'.__PS_BASE_URI__.'modules/verifonepayment/logo.png" alt="Verifone" style="width:150px;" class="verifone-logo"/>
				<h1>'.$module->l('Payment failed').'</h1>
				<div class="verifone-messages">
					<p>'.$module->l('Something went wrong with your order, please go back and try again or select another payment option.').'</p>
				</div>
				<div class="verifone-buttonrow">
					<a href="'.verifonepayment::getPageLink('order.php', false).'?step=3'.'"><button type="button" class="verifone-button verifone-back" >'.$module->l('Back to payment options').'</button></a>
				</div>
			</div>
		</div>
	';

	return $_html;
}
include(dirname(__FILE__).'/../../footer.php');


?>
