<?php

include(dirname(__FILE__).'/../../config/config.inc.php');
include(dirname(__FILE__).'/../../init.php');
ob_start();
$context = Context::getContext();
$fc = new Frontcontroller();
$fc->setmedia();
include(dirname(__FILE__).'/../../header.php');
include(dirname(__FILE__).'/Helper/Cryptutils.php');

if (!$cookie->isLogged() && !$cookie->is_guest)
    Tools::redirect('authentication.php?back=order.php');

$verifone_payment_type = $_GET['paymenttype'];
$redirectHtml = getRedirectHtml($verifone_payment_type);

echo $redirectHtml;

function _displayStart(){

	$html = '<h1>Loading paymentservice...</h1>';

	return $html;
}

function saveOrderToDatabase($order_id, $order_amount, $server){
  $db = Db::getInstance();
  //Create the table if it does not exist
  $sql = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."verifone_orders`".
  		"(id INT(255), amount INT(255), server VARCHAR(255), ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP,".
  		"PRIMARY KEY(id, amount, server));";
  $db->ExecuteS($sql);

  $db->insert(
  	'verifone_orders',
  	array(
  		'id' => $order_id,
  		'amount' => $order_amount,
  		'server' => $server));
}

function getBestServer(){

    if(!(ini_get('allow_url_fopen'))) {
        Mage::throwException("Configuration error: allow_url_fopen must be enabled");
    }

    $verifone_settings = getSettings();
    $payment_urls = array();

    $payment_urls[] = $verifone_settings['purl1'];
    $second_url = $verifone_settings['purl2'];
    $third_url = $verifone_settings['purl3'];
    if(!empty($second_url)) { $payment_urls[] = $second_url; }
    if(!empty($third_url)) { $payment_urls[] = $third_url; }

      //shuffle to get random node for loadbalancing
    shuffle($payment_urls);

    // GET must result HTTP 200 OK and empty contents
    // anything else indicates that the payment system node is not available
    // file_get_contents requires valid ssl certificate
    foreach ($payment_urls as $url) {

      $fc = file_get_contents($url);
      if($fc !== false and $fc == '' and strpos($http_response_header[0],'200 OK') !== false) {
        return $url;
      }
	}

    //Return false on error
    return false;
  }

  function getFirstServer(){
    $verifone_settings = getSettings();
    return $verifone_settings['purl1'];
  }

  function getSettings(){
    
    if(Configuration::get('verifonepaymenttitle') != false){
      $title = Configuration::get('verifonepaymenttitle');
    }else{
      $title = "Kortbetalning";
    }
    
    $enabled = Configuration::get('verifonepaymentenabled');
    
    $merccode = Configuration::get('verifonepaymentmerccode');
    $privkey = Configuration::get('verifonepaymentprivkey');
    $pubkey = Configuration::get('verifonepaymentpubkey');
    $purl1 = Configuration::get('verifonepaymentpurl1');
    $purl2 = Configuration::get('verifonepaymentpurl2');
    $purl3 = Configuration::get('verifonepaymentpurl3');
    
    $languagecode = Configuration::get('verifonepaymentlanguagecode');
    $chkavail = Configuration::get('verifonepaymentchkavail');
    $skipconfirm = Configuration::get('verifonepaymentskipconfirm');

    $verifone_set = array(
      'title' => $title, 
      'enabled' => $enabled ,
      'merccode' => $merccode ,
      'privkey' => $privkey ,
      'pubkey' => $pubkey ,
      'purl1' => $purl1 ,
      'purl2' => $purl2 ,
      'purl3' => $purl3 ,
      'chkavail' => $chkavail ,
      'skipconfirm' => $skipconfirm
    );
    return $verifone_set;
  }

function getCustomerObject($cart_cusid){
	$customers = Customer::getCustomers();

	foreach ($customers as $customer) {
		if($customer["id_customer"] == $cart_cusid){
			return $customer;
		}
	}
	return false;
}

function getCustomerAddress($customerid){
  $db = Db::getInstance(); 
  $query = "SELECT * FROM `"._DB_PREFIX_."address` WHERE `id_customer` = ".$customerid.";";
  $result = $db->ExecuteS($query);
  //var_dump($result);
  return $result;
}

function getCustomerCountryIso($id_country){
  $db = Db::getInstance();
  $query = "SELECT `iso_code` FROM `"._DB_PREFIX_."country` WHERE `id_country` = '".$id_country."';";
  $result = $db->ExecuteS($query);
  $isocode;
  foreach ($result as $row) {
    $isocode = $row["iso_code"];
  }
  $iso_code_nbr = _convert_country_code_to_numeric($isocode);
  return $iso_code_nbr;
}

function _sanitise($data, $maxlen, $reverse=false) {
    $data = str_replace('"','',str_replace('\\','',$data));
    if(!$reverse) { return substr($data,0,$maxlen); } else {
    return substr($data, 0 - $maxlen);
   }
}

function getRedirectHtml($paymenttype){
    $_settings = getSettings();
    if($_settings['chkavail'] == 'true'){
      $action = getBestServer();
    }else{
      $action = getFirstServer();
    }
    
    if(!$action) { error_log("No server available!"); }
    
    global $cart;
    $fields = getFormFields($cart, $paymenttype);
    saveOrderToDatabase($cart->id, $cart->getOrderTotal(true)*100, $action);    
    
    $html = '<html><body><form method="POST" id="pay" action="'. $action .'">';
    $html.= 'Redirecting to VerifonePayment.';
    foreach ($fields as $field=>$value) {
      $html .= "<input type=\"hidden\" name=\"$field\" value=\"$value\" />\n";
    }

    $html.= '<br />';
    $html.= '<script type="text/javascript">document.getElementById("pay").submit();</script>'; 
    $html .= '<input type="submit" />';
    $html.= '</form></body></html>';


    return $html;
}

function getCurrency($id_currency){
  $db = Db::getInstance();
  $query = "SELECT `iso_code_num` FROM `"._DB_PREFIX_."currency` WHERE `id_currency` = '".$id_currency."';";
  $result = $db->ExecuteS($query);
  $isocode;
  foreach ($result as $row) {
    $isocode=$row["iso_code_num"];
  }
  return $isocode;
}

//get HTML form data
function getFormFields($cartObj, $paymenttype) {

    $order_id = $cartObj->id;
    $customer = getCustomerObject($cartObj->id_customer);
    $customer_address = getCustomerAddress($cartObj->id_customer)[0];
    
    $order_gross_amount = $cartObj->getOrderTotal(true) * 100;
    $order_vat_amount = ($cartObj->getOrderTotal(true) - $cartObj->getOrderTotal(false))*100;
    $order_net_amount = $order_gross_amount - $order_vat_amount;

    $isocode = getCurrency($cartObj->id_currency);
    $currency_code = $isocode;

    $order_timestamp = gmdate("Y-m-d H:i:s");
        
    $fields = array();
    $fields['locale-f-2-5_payment-locale'] = Configuration::get('verifonepaymentlanguagecode');
    $fields['t-f-14-19_payment-timestamp'] = $order_timestamp;
    $fields['s-f-1-36_merchant-agreement-code'] = Configuration::get('verifonepaymentmerccode');
    $fields['s-f-1-36_order-number'] = $order_id;
    $fields['t-f-14-19_order-timestamp'] = $order_timestamp;
    $fields['i-f-1-3_order-currency-code'] = $currency_code;
    $fields['l-f-1-20_order-gross-amount'] = $order_gross_amount;
    $fields['l-f-1-20_order-net-amount'] = $order_net_amount;
    $fields['l-f-1-20_order-vat-amount'] = $order_vat_amount;

    $fields['s-f-1-30_buyer-first-name'] = substr($customer_address['firstname'],0,30);
    $fields['s-f-1-30_buyer-last-name'] = substr($customer_address['lastname'],0,30);

    $telephone = $customer_address['phone'];
    if(!empty($telephone)) {
      $fields['s-t-1-30_buyer-phone-number'] = _sanitise($telephone,30);
    }

    $fields['s-f-1-100_buyer-email-address'] = _sanitise($customer['email'],30);

    $fields['s-t-1-30_delivery-address-line-one'] = _sanitise($customer_address['address1'],30);
    $addr2 = _sanitise($customer_address['address2'],30);
    if(!empty($addr2)) {
      $fields['s-t-1-30_delivery-address-line-two'] = _sanitise($addr2,30);
    }
    
    $city = $customer_address['city'];
    if(!empty($city)) {
      $fields['s-t-1-30_delivery-address-city'] = _sanitise($city,30);
    }

    $postcode = $customer_address['postcode'];
    if(!empty($postcode)) {
      $fields['s-t-1-30_delivery-address-postal-code'] = _sanitise($postcode,30);
    }

    $iso_country = getCustomerCountryIso($customer_address['id_country']);
    $fields['i-t-1-3_delivery-address-country-code'] = $iso_country;

    $shop_url = Tools::getShopDomainSsl(true) . __PS_BASE_URI__;
    
    $fields['s-f-5-256_success-url'] = $shop_url . "modules/verifonepayment/verifone_success.php";// URL FOR SUCCESS PAGE
    $fields['s-f-5-256_rejected-url'] = $shop_url . "modules/verifonepayment/verifone_failed.php";//URL FOR REJECTED PAGE
    $fields['s-f-5-256_cancel-url'] = $shop_url . "modules/verifonepayment/verifone_failed.php";//URL FOR CANCEL PAGE
    $fields['s-f-5-256_expired-url'] = $shop_url . "modules/verifonepayment/verifone_failed.php";//URL FOR EXPIRED PAGE
    $fields['s-f-5-256_error-url'] = $shop_url . "modules/verifonepayment/verifone_failed.php"; //URL FOR ERROR PAGE
    
    $fields['s-t-5-256_change-server-to-server-success-url'] = $shop_url . "modules/verifonepayment/verifone_response.php";
    
    $fields['s-t-1-32_type-of-payment'] = $paymenttype;
    
    $fields['s-f-1-30_software'] = "Prestashop";
    $fields['s-f-1-10_software-version'] = _PS_VERSION_;

    $fields['i-f-1-11_interface-version'] = "5";

    $tokendata =  sprintf("%s;%s;%s",
                          $fields['s-f-1-36_merchant-agreement-code'],
                          $fields['s-f-1-36_order-number'],
                          $order_timestamp
                        );
    $fields['s-f-32-32_payment-token'] = strtoupper(substr(hash('sha256',$tokendata),0,32));
    
  	// basket items
    $items_tax = 0;
    $items_net_price = 0;
    $items_gross_price = 0;
    $items = $cartObj->getProducts();
    $basket_item_count = 0;

    if($items) {
      foreach($items as $item) {
        $item_count = $item['quantity'];
        $fields["s-t-1-30_bi-name-$basket_item_count"] = _sanitise($item['name'],30);
        $fields["i-t-1-11_bi-unit-count-$basket_item_count"] = $item_count;
        $fields["l-t-1-20_bi-unit-cost-$basket_item_count"] = round($item['price'],2)*100;
        $fields["l-t-1-20_bi-net-amount-$basket_item_count"] = 
          $fields["l-t-1-20_bi-unit-cost-$basket_item_count"] * $item_count;
        $fields["l-t-1-20_bi-gross-amount-$basket_item_count"] = 
          round($item['price_wt'],2) * 100 * $item_count;
        $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = round($item['rate'],2)*100;
        $fields["i-t-1-4_bi-discount-percentage-$basket_item_count"] = 0;
        $items_tax +=  $fields["l-t-1-20_bi-gross-amount-$basket_item_count"] - $fields["l-t-1-20_bi-net-amount-$basket_item_count"];
        $items_net_price +=  (int)$fields["l-t-1-20_bi-net-amount-$basket_item_count"];
        $items_gross_price += (int)$fields["l-t-1-20_bi-gross-amount-$basket_item_count"];

        if(++$basket_item_count == 48) { break; }  // only 50 basket items supported, one must be reserved for shipping and one for discounts
      }

      // shipping
      if($cartObj->getTotalShippingCost(null,true) > 0){
	      $items_tax += $cartObj->getTotalShippingCost(null,true) - $cartObj->getTotalShippingCost(null,false);
	      $fields["s-t-1-30_bi-name-$basket_item_count"] = "Shipping";
	      $fields["l-t-1-20_bi-unit-cost-$basket_item_count"] = round($cartObj->getTotalShippingCost(null,false),2)*100;
	      $fields["i-t-1-11_bi-unit-count-$basket_item_count"] = 1;
	      $fields["l-t-1-20_bi-gross-amount-$basket_item_count"] = round($cartObj->getTotalShippingCost(null,true),2)*100;
	      $fields["l-t-1-20_bi-net-amount-$basket_item_count"] = $fields["l-t-1-20_bi-unit-cost-$basket_item_count"];
	      $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = round(($cartObj->getTotalShippingCost(null,true) - $cartObj->getTotalShippingCost(null,false))/$cartObj->getTotalShippingCost(null,false),2)*100*100;

	      $fields["i-t-1-4_bi-discount-percentage-$basket_item_count"] =  0;
	      $items_tax +=  (int) $fields["l-t-1-20_bi-gross-amount-$basket_item_count"] - $fields["l-t-1-20_bi-net-amount-$basket_item_count"];
	      $items_net_price +=  (int) $fields["l-t-1-20_bi-net-amount-$basket_item_count"];
	      $items_gross_price += (int) $fields["l-t-1-20_bi-gross-amount-$basket_item_count"];
      }
      // discount
      $discountAmount =  $order_gross_amount - $items_gross_price;
      if(abs($discountAmount) >= 1 ) { 
         ++$basket_item_count;
         $fields["s-t-1-30_bi-name-$basket_item_count"] = "Discount";
         $fields["i-t-1-11_bi-unit-count-$basket_item_count"] = 1;
         $fields["l-t-1-20_bi-unit-cost-$basket_item_count"] = round($order_net_amount - $items_net_price,0);
         $fields["l-t-1-20_bi-gross-amount-$basket_item_count"] = round($order_gross_amount - $items_gross_price,0);
         $fields["l-t-1-20_bi-net-amount-$basket_item_count"] = round($order_net_amount - $items_net_price,0);
         if($fields["l-t-1-20_bi-net-amount-$basket_item_count"] != 0) { 
           $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = round(($fields["l-t-1-20_bi-gross-amount-$basket_item_count"]  - $fields["l-t-1-20_bi-net-amount-$basket_item_count"]) / $fields["l-t-1-20_bi-net-amount-$basket_item_count"],2) * 100 * 100; 
         } else {
           $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = 0;
         }
         if(abs($fields["i-t-1-4_bi-vat-percentage-$basket_item_count"]) > 10000) {
           // could be absurd numbers due to rounding errors
           $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = 0;
         }
         
         $fields["i-t-1-4_bi-discount-percentage-$basket_item_count"] = 0;
      }
    }
    if(Configuration::get('verifonepaymentskipconfirm') == "true") {
      $fields["i-t-1-1_skip-confirmation-page"] = "1";
    }
    $cryptutils = new Verifone_VerifonePayment_Helper_Cryptutils;
    $fields["s-t-256-256_signature-one"] = $cryptutils->generatesignature($cryptutils->formatparameters($fields));

   	return $fields;
}

function _convert_country_code_to_numeric($cc) {
    $codes = array(
      'AF' =>     4,          
      'AL' =>     8,          
      'DZ' =>    12,          
      'AS' =>    16,          
      'AD' =>    20,          
      'AO' =>    24,          
      'AI' =>   660,          
      'AQ' =>    10,          
      'AG' =>    28,          
      'AR' =>    32,          
      'AM' =>    51,          
      'AW' =>   533,          
      'AU' =>    36,          
      'AT' =>    40,          
      'AZ' =>    31,          
      'BS' =>    44,          
      'BH' =>    48,          
      'BD' =>    50,          
      'BB' =>    52,          
      'BY' =>   112,          
      'BE' =>    56,          
      'BZ' =>    84,          
      'BJ' =>   204,          
      'BM' =>    60,          
      'BT' =>    64,          
      'BO' =>    68,          
      'BA' =>    70,          
      'BW' =>    72,          
      'BV' =>    74,          
      'BR' =>    76,          
      'IO' =>    86,          
      'BN' =>    96,          
      'BG' =>   100,          
      'BF' =>   854,          
      'BI' =>   108,          
      'KH' =>   116,          
      'CM' =>   120,          
      'CA' =>   124,          
      'CV' =>   132,          
      'KY' =>   136,          
      'CF' =>   140,          
      'TD' =>   148,          
      'CL' =>   152,          
      'CN' =>   156,          
      'CX' =>   162,          
      'CC' =>   166,          
      'CO' =>   170,          
      'KM' =>   174,          
      'CG' =>   178,          
      'CK' =>   184,          
      'CR' =>   188,          
      'CI' =>   384,          
      'HR' =>   191,          
      'CU' =>   192,          
      'CY' =>   196,          
      'CZ' =>   203,          
      'DK' =>   208,          
      'DJ' =>   262,          
      'DM' =>   212,          
      'DO' =>   214,          
      'TP' =>   626,          
      'EC' =>   218,          
      'EG' =>   818,          
      'SV' =>   222,          
      'GQ' =>   226,          
      'ER' =>   232,          
      'EE' =>   233,          
      'ET' =>   231,          
      'FK' =>   238,          
      'FO' =>   234,          
      'FJ' =>   242,          
      'FI' =>   246,          
      'FR' =>   250,          
      'FX' =>   249,          
      'GF' =>   254,          
      'PF' =>   258,          
      'TF' =>   260,          
      'GA' =>   266,          
      'GM' =>   270,          
      'GE' =>   268,          
      'DE' =>   276,          
      'GH' =>   288,          
      'GI' =>   292,          
      'GR' =>   300,          
      'GL' =>   304,          
      'GD' =>   308,          
      'GP' =>   312,          
      'GU' =>   316,          
      'GT' =>   320,          
      'GN' =>   324,          
      'GW' =>   624,          
      'GY' =>   328,          
      'HT' =>   332,          
      'HM' =>   334,          
      'VA' =>   336,          
      'HN' =>   340,          
      'HK' =>   344,          
      'HU' =>   348,          
      'IS' =>   352,          
      'IN' =>   356,          
      'ID' =>   360,          
      'IR' =>   364,          
      'IQ' =>   368,          
      'IE' =>   372,          
      'IL' =>   376,          
      'IT' =>   380,          
      'JM' =>   388,          
      'JP' =>   392,          
      'JO' =>   400,          
      'KZ' =>   398,          
      'KE' =>   404,          
      'KI' =>   296,          
      'KP' =>   408,          
      'KR' =>   410,          
      'KW' =>   414,          
      'KG' =>   417,          
      'LA' =>   418,          
      'LV' =>   428,          
      'LB' =>   422,          
      'LS' =>   426,          
      'LR' =>   430,          
      'LY' =>   434,          
      'LI' =>   438,          
      'LT' =>   440,          
      'LU' =>   442,          
      'MO' =>   446,          
      'MK' =>   807,          
      'MG' =>   450,          
      'MW' =>   454,          
      'MY' =>   458,          
      'MV' =>   462,          
      'ML' =>   466,          
      'MT' =>   470,          
      'MH' =>   584,          
      'MQ' =>   474,          
      'MR' =>   478,          
      'MU' =>   480,          
      'YT' =>   175,          
      'MX' =>   484,          
      'FM' =>   583,          
      'MD' =>   498,          
      'MC' =>   492,          
      'MN' =>   496,          
      'MS' =>   500,          
      'MA' =>   504,          
      'MZ' =>   508,          
      'MM' =>   104,          
      'NA' =>   516,          
      'NR' =>   520,          
      'NP' =>   524,          
      'NL' =>   528,          
      'AN' =>   530,          
      'NC' =>   540,          
      'NZ' =>   554,          
      'NI' =>   558,          
      'NE' =>   562,          
      'NG' =>   566,          
      'NU' =>   570,          
      'NF' =>   574,          
      'MP' =>   580,          
      'NO' =>   578,          
      'OM' =>   512,          
      'PK' =>   586,          
      'PW' =>   585,          
      'PA' =>   591,          
      'PG' =>   598,          
      'PY' =>   600,          
      'PE' =>   604,          
      'PH' =>   608,          
      'PN' =>   612,          
      'PL' =>   616,          
      'PT' =>   620,          
      'PR' =>   630,          
      'QA' =>   634,          
      'RE' =>   638,          
      'RO' =>   642,          
      'RU' =>   643,          
      'RW' =>   646,          
      'KN' =>   659,          
      'LC' =>   662,          
      'VC' =>   670,          
      'WS' =>   882,          
      'SM' =>   674,          
      'ST' =>   678,          
      'SA' =>   682,          
      'SN' =>   686,          
      'SC' =>   690,          
      'SL' =>   694,          
      'SG' =>   702,          
      'SK' =>   703,          
      'SI' =>   705,          
      'SB' =>    90,          
      'SO' =>   706,          
      'ZA' =>   710,          
      'GS' =>   239,          
      'ES' =>   724,          
      'LK' =>   144,          
      'SH' =>   654,          
      'PM' =>   666,          
      'SD' =>   736,          
      'SR' =>   740,          
      'SJ' =>   744,          
      'SZ' =>   748,          
      'SE' =>   752,          
      'CH' =>   756,          
      'SY' =>   760,          
      'TW' =>   158,          
      'TJ' =>   762,          
      'TZ' =>   834,          
      'TH' =>   764,          
      'TG' =>   768,          
      'TK' =>   772,          
      'TO' =>   776,          
      'TT' =>   780,          
      'TN' =>   788,          
      'TR' =>   792,          
      'TM' =>   795,          
      'TC' =>   796,          
      'TV' =>   798,          
      'UG' =>   800,          
      'UA' =>   804,          
      'AE' =>   784,          
      'GB' =>   826,          
      'US' =>   840,          
      'UM' =>   581,          
      'UY' =>   858,          
      'UZ' =>   860,          
      'VU' =>   548,          
      'VE' =>   862,          
      'VN' =>   704,          
      'VG' =>    92,          
      'VI' =>   850,          
      'WF' =>   876,          
      'EH' =>   732,          
      'YE' =>   887,          
      'YU' =>   891,          
      'ZR' =>   180,          
      'ZM' =>   894,          
      'ZW' =>   716);

    if(isset($codes[$cc])) {
      	return $codes[$cc];
    } else {
    	return "246";  // default to Finland
    }
}

include_once(dirname(__FILE__).'/../../footer.php');

?>
