<?php
/*
 * Cryptutils functions for VerifonePayment
 */

class Verifone_VerifonePayment_Helper_Cryptutils {
 // Cryptutils functions
 public function formatparameters($parameters) {
   ksort($parameters, SORT_STRING);
   $formatedresult = "";
  foreach ($parameters as $key => $value)  {
    $value = str_replace(';',';;',$value);
    $formatedresult .= sprintf("%s=%s;", $key, $value);
  }
  return $formatedresult;
 }
  /** Creates signature for data
 * @param $data data to creta
 * @return string
 */
 public function generatesignature($data) {
   $shop_private_key_file = Configuration::get('verifonepaymentprivkey');
   set_include_path(get_include_path() . PATH_SEPARATOR . dirname(__FILE__));
   $key = file_get_contents($shop_private_key_file, true);
   if($key === false) {
     $this->raise_error('Key file could not be read.');
     return false;
   }
   require_once('Crypt/RSA.php');
   $rsa = new Crypt_RSA();
   $rsa->setSignatureMode(CRYPT_RSA_SIGNATURE_PKCS1);
   $rsa->loadKey($key);
   $signature = $rsa->sign($data);
   return strtoupper(bin2hex($signature));
  }
/** Verifies the data signature
 * @param $datatoverify data to verify signature for
 * @param $signaturedata signature data as hex string
 * @return bool true - signature valid, false - invalid
 */
 public function verifysignature($datatoverify, $signaturedata) {
    $pay_page_public_key_file = Configuration::get('verifonepaymentpubkey');
    set_include_path(get_include_path() . PATH_SEPARATOR . dirname(__FILE__));
    $key = file_get_contents($pay_page_public_key_file, true);
    
   if($key === false) {
     $this->raise_error($this->__('Key file could not be read.'));
     return false;
    }

    require_once('Crypt/RSA.php');
    $rsa = new Crypt_RSA();
    $rsa->setSignatureMode(CRYPT_RSA_SIGNATURE_PKCS1);
    $rsa->loadKey($key);
    return $rsa->verify($datatoverify, pack("H*" , $signaturedata)) ? true : false;
  }

  public function raise_error($msg) {
    error_log("Error in Cryptutils : ".$msg); 
  }

}

//EOF
