<?php

/*

*/

class Point_PointPayment_RedirectController extends Mage_Core_Controller_Front_Action
{

    public function getCheckout()
    {
        return Mage::getSingleton('checkout/session');
    }

    protected function _expireAjax()
    {
        if (!Mage::getSingleton('checkout/session')->getQuote()->hasItems()) {
            $this->getResponse()->setHeader('HTTP/1.1','403 Session Expired');
            exit;
        }
    }

    protected function _getOrder()
    {
        $orderIncrementId = $this->getCheckout()->getLastRealOrderId();
        $order = Mage::getModel('sales/order')->loadByIncrementId($orderIncrementId);
        return $order;
    }

    public function reactivateQuote($quote_id)
    {
        $quote = Mage::getModel('sales/quote')->load($quote_id);
        $quote->setIsActive(true);
        $quote->save();
    }

    public function indexAction()
    {
        try {
            $order = $this->_getOrder();
            $order->setState(Mage_Sales_Model_Order::STATE_PENDING_PAYMENT, true)->save();
            $this->getResponse()
                ->setHeader('Content-type', 'text/html; charset=utf8')
                ->setBody($this->getLayout()
                ->createBlock('PointPayment/redirect')
                ->toHtml());
        } catch (Exception $e) {
            Mage::getSingleton('core/session')->addError($e->getMessage());
            $this->reactivateQuote($order->getQuoteId());
            $order->cancel();
            $history = $this->__('Payment was canceled. Cancel reason: ') . $e->getMessage();
            $order->addStatusToHistory($order->getStatus(), $history);
            $order->save();
            $this->defaultAction();
        }
    }

    public function successAction()
    {
        $late_post = false;
        $order = Mage::getModel('sales/order')->loadByIncrementId((int)$_POST['s-f-1-36_order-number']);
        if (Mage::getSingleton('checkout/session')->getLastRealOrderId()!=$order->getIncrementId()) {
            $late_post = true;
        }
        unset($_POST["s-t-1-40_shop-receipt__phase"]);
        $signedformdata = $_POST;
        unset($signedformdata["s-t-256-256_signature-one"]);
        unset($signedformdata["s-t-256-256_signature-two"]);  
        $cryptutils = $cryptutils = Mage::helper('PointPayment/cryptutils');
        $signature_valid = @$cryptutils->verifysignature($cryptutils->formatparameters($signedformdata), $_POST["s-t-256-256_signature-one"]);

        if($signature_valid and 
            isset($_POST['l-f-1-20_transaction-number']) and
            !empty($_POST['l-f-1-20_transaction-number']) and
            abs($_POST['l-f-1-20_order-gross-amount'] - (round($order->getGrandTotal(), 2)*100)) < 1 and
            !isset($_POST['s-t-1-30_cancel-reason'])) {
    
            // the order might be handled already
            if($order->getState() != Mage_Sales_Model_Order::STATE_PROCESSING) {
                $order->sendNewOrderEmail();  // in case of multiple returns we don't want email each time
                $order->setData('ext_order_id', preg_replace("/[^0-9]+/","",$_POST['l-f-1-20_transaction-number']));
                $order->setData('point_payment_method', preg_replace("/[^0-9-\w\s]+/","",$_POST['s-f-1-30_payment-method-code']));
                $order->save(); 
                $this->_saveInvoice($order);
            }

            if($late_post) {
                // no session, i.e. late POST from the payment system. We must signal 200 OK.
                header("HTTP/1.1 200 OK");
                die('<html><head><meta http-equiv="refresh" content="0;url=' . Mage::getUrl('checkout/cart') . '"></head></html>');
            } else {
                $this->_redirect('checkout/onepage/success');
            }
        } else {
            Mage::throwException($this->__('Payment verification failed')); 
        }
        return;
    }

    public function rejectedAction()
    {
        $this->_verifyCancel();
        $this->_cancelOrder();
        $this->defaultAction();
    }
  
    public function cancelAction()
    {
        $this->_verifyCancel();
        $this->_cancelOrder();
        $this->defaultAction();
    }
  
    public function expiredAction()
    {
        $this->_verifyCancel();
        $this->_cancelOrder();
        $this->defaultAction();
    }
  
    public function errorAction()
    {
        $this->_verifyCancel();
        $this->_cancelOrder();
        $this->defaultAction();
    }

    protected function defaultAction()
    {
        $this->_redirect('checkout/onepage');
    }
  
    protected function _verifyCancel()
    {
        $signedformdata = $_POST;
        unset($signedformdata["s-t-1-40_shop-order__phase"]);
        unset($signedformdata["s-t-256-256_signature-one"]);
        unset($signedformdata["s-t-256-256_signature-two"]);  
        $cryptutils = $cryptutils = Mage::helper('PointPayment/cryptutils');
        $signature_valid = @$cryptutils->verifysignature($cryptutils->formatparameters($signedformdata), $_POST["s-t-256-256_signature-one"]);
        if(!$signature_valid) {
            Mage::throwException($this->__('Payment interface error')); 
        } else {
            return true;
        }
    }
  
    protected function _cancelOrder()
    {
        $order = Mage::getModel('sales/order');
        if(!$order) { return; }
        if (isset($_POST['s-f-1-36_order-number'])) {
            $orderIncrementId = $_POST['s-f-1-36_order-number'];
        } else {
            $orderIncrementId = Mage::getSingleton('checkout/session')->getLastRealOrderId();
// We really shouldn't trust the session when coming back, as it can be an old message.
// But I have only been able to verify that cancel and reject has this variable.
// If there is some sort of combination that doesn't contain the order id, comment this line out...
            return;
        }
        $order->loadByIncrementId($orderIncrementId);
        if(!$order || !$order->getId()) { return; }
        $this->reactivateQuote($order->getQuoteId());
        $order->cancel();
        $history = $this->__('Payment was canceled. Cancel reason: ') . $_POST['s-t-1-30_cancel-reason'];
        $order->addStatusToHistory($order->getStatus(), $history);
        $order->save();
    }
    

    protected function _saveInvoice(Mage_Sales_Model_Order $order)
    {
        if($order->canInvoice()) {
            $invoice = $order->prepareInvoice();
	        $invoice->register()->capture();
	        Mage::getModel('core/resource_transaction')->addObject($invoice)->addObject($invoice->getOrder())->save();
            return true;
        }
        return false;
    }
	
}
