<?php

/*
 * Magento Point Payment

 */


class Point_PointPayment_Model_Checkout extends Mage_Payment_Model_Method_Abstract
{
    protected $_code  = 'PointPayment';
    protected $_formBlockType = 'PointPayment/form';
    protected $_paymentMethod = 'shared';


    public function getCheckout()
    {
        return Mage::getSingleton('checkout/session');
    }

    public function getOrderPlaceRedirectUrl()
    {
      return Mage::getUrl('PointPayment/redirect');
    }

    // Return payment url to be used for connecting to the payment system
    // This function implements the Availability Get operation in the Point-e-commerce-payment interface
    // Required configuration: allow_url_fopen must be enabled
    public function getUrl()
    {
        // check that the configuration is correct
        if(!(ini_get('allow_url_fopen'))) {
            Mage::throwException("Configuration error: allow_url_fopen must be enabled");
        }

        $payment_urls = array();
        $payment_urls[] = $this->getConfigData('pay_page_url_one');
        $second_url = $this->getConfigData('pay_page_url_two');
        $third_url = $this->getConfigData('pay_page_url_three');
        if(!empty($second_url)) { $payment_urls[] = $second_url; }
        if(!empty($third_url)) { $payment_urls[] = $third_url; }

        shuffle($payment_urls);
    
        foreach($payment_urls as $url) {   
            if($this->getConfigData('validate_url') == 0) {
                return $url;
            }
            // GET must result HTTP 200 OK and empty contents
            // anything else indicates that the payment system node is not available
            // file_get_contents requires valid ssl certificate
            $fc = @file_get_contents($url);
            if($fc !== false and $fc == '' and
                strpos($http_response_header[0],'200 OK') !== false) {
                return $url;
            }
        }
        // flag error 
        return false;
    }


    protected function _getOrder()
    {
        $orderIncrementId = $this->getCheckout()->getLastRealOrderId();
        $order = Mage::getModel('sales/order')->loadByIncrementId($orderIncrementId);
        return $order;
    }

    public function capture(Varien_Object $payment, $amount)
    {
        if($payment->getStatus() != self::STATUS_APPROVED) {
            $payment->setStatus(self::STATUS_APPROVED)
                ->setTransactionId($this->getTransactionId())
                ->setIsTransactionClosed(0);
        }
        return $this;
    }



//get HTML form data
    public function getFormFields()
    {
//        $order_id = $this->getCheckout()->getLastRealOrderId();
        $order = $this->_getOrder();
        $order_id = $order->getIncrementId();
        $shipping_address = $order->getShippingAddress();
        $billing_address = $order->getBillingAddress();
        $country = $this->_convert_country_code_to_numeric($shipping_address->getCountry());
        $order_gross_amount   = round($order->getGrandTotal(), 2)*100;
        $order_vat_amount = round($order->getTaxAmount(),2)*100;
        $order_net_amount = $order_gross_amount - $order_vat_amount;
        $currency_code = $this->getConfigData('currency');
        if (!$currency_code) $currency_code = '978'; // euro is default
        $order_timestamp = gmdate("Y-m-d H:i:s");
        
  
        $fields = array();
        
        $fields['locale-f-2-5_payment-locale'] = 'fi_FI'; // Setting?
        $fields['t-f-14-19_payment-timestamp'] = $order_timestamp;
        $fields['s-f-1-36_merchant-agreement-code'] = $this->getConfigData('merchant_agreement_code');
        $fields['s-f-1-36_order-number'] = $order_id;
        $fields['t-f-14-19_order-timestamp'] = $order_timestamp;
        $fields['i-f-1-3_order-currency-code'] = $currency_code;
        $fields['l-f-1-20_order-gross-amount'] = $order_gross_amount;
        $fields['l-f-1-20_order-net-amount'] = $order_net_amount;
        $fields['l-f-1-20_order-vat-amount'] = $order_vat_amount;
        $fields['s-f-1-30_buyer-first-name'] = substr($billing_address->getFirstname(),0,30);
        $fields['s-f-1-30_buyer-last-name'] = substr($billing_address->getLastname(),0,30);
        $telephone = $billing_address->getTelephone();
        if(!empty($telephone)) {
            $fields['s-t-1-30_buyer-phone-number'] = $this->_sanitise($telephone,30);
        }
   
        $fields['s-f-1-100_buyer-email-address'] = $this->_sanitise($order->getData('customer_email'),30);

        $state = $shipping_address->getRegion();
        $fields['s-t-1-30_delivery-address-line-one'] = $this->_sanitise($shipping_address->getStreet1(),30);
        $addr2 =  $this->_sanitise($shipping_address->getStreet2(),30);
        if(!empty($addr2)) {
            $fields['s-t-1-30_delivery-address-line-two'] = $this->_sanitise($addr2,30);
            if(!empty($state)) {
                $fields['s-t-1-30_delivery-address-line-three'] = $this->_sanitise($state,30);
            }
        } else {
           if(!empty($state)) {
               $fields['s-t-1-30_delivery-address-line-two'] = $this->_sanitise($state,30);
           }
        }
        $city = $shipping_address->getCity();
        if(!empty($city)) {
            $fields['s-t-1-30_delivery-address-city'] = $this->_sanitise($city,30);
        }
        $postcode = $shipping_address->getPostcode();
        if(!empty($postcode)) {
            $fields['s-t-1-30_delivery-address-postal-code'] = $this->_sanitise($postcode,30);
        }
   
        $fields['i-t-1-3_delivery-address-country-code'] = $country;


        $fields['s-f-5-128_success-url'] = Mage::getUrl('PointPayment/redirect/success',array('_secure' => true));
        $fields['s-f-5-128_rejected-url'] = Mage::getUrl('PointPayment/redirect/rejected', array('_secure'=>true));
        $fields['s-f-5-128_cancel-url'] =  Mage::getUrl('PointPayment/redirect/cancel', array('_secure'=>true));
        $fields['s-f-5-128_expired-url'] =  Mage::getUrl('PointPayment/redirect/expired', array('_secure'=>true));;
        $fields['s-f-5-128_error-url'] =  Mage::getUrl('PointPayment/redirect/error', array('_secure'=>true));
        $fields['s-f-1-30_software'] = "Magento";
        $fields['s-f-1-10_software-version'] = $this->_sanitise(Mage::getVersion(), 10, true);



        $fields['i-f-1-11_interface-version'] = "3";
        $fields['s-t-1-30_payment-method-code'] = '';

        $tokendata =  sprintf("%s;%s;%s",
                         $fields['s-f-1-36_merchant-agreement-code'],
                         $fields['s-f-1-36_order-number'],
                         $order_timestamp
                       );
        $fields['s-f-32-32_payment-token'] = strtoupper(substr(hash('sha256',$tokendata),0,32));


  // basket items
/* debug
*/

        $items_tax = 0;
        $items_net_price = 0;
        $items_gross_price = 0;
        $items = $order->getAllItems();
        $basket_item_count = 0;
        if($items) {
            foreach($items as $item) {
                if ($item->getParentItem()) {
                    continue;
                }

                $item_count = $item->getQtyToInvoice();
  
                $fields["s-t-1-30_bi-name-$basket_item_count"] = $this->_sanitise($item->getName(),30);
                $fields["i-t-1-11_bi-unit-count-$basket_item_count"] = $item_count;
                $fields["l-t-1-20_bi-unit-cost-$basket_item_count"] = round($item->getPrice(),2)*100;
                $fields["l-t-1-20_bi-net-amount-$basket_item_count"] = 
                $fields["l-t-1-20_bi-unit-cost-$basket_item_count"] * $item_count;
                $fields["l-t-1-20_bi-gross-amount-$basket_item_count"] = 
                round($item->getPriceInclTax()*100*$item_count,0);

                $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = round($item->getTaxPercent(),2)*100;
                $fields["i-t-1-4_bi-discount-percentage-$basket_item_count"] = 0;

                $items_tax +=  $fields["l-t-1-20_bi-gross-amount-$basket_item_count"] - $fields["l-t-1-20_bi-net-amount-$basket_item_count"];
                $items_net_price +=  (int)$fields["l-t-1-20_bi-net-amount-$basket_item_count"];
                $items_gross_price += (int)$fields["l-t-1-20_bi-gross-amount-$basket_item_count"];
 
                if(++$basket_item_count == 48) { // only 50 basket items supported, one must be reserved for shipping and one for discounts
                    break;
                }
            } 

            // shipping
            $items_tax += $order->getShippingTaxAmount();
               $fields["s-t-1-30_bi-name-$basket_item_count"] = substr($order->getShippingDescription(),0,30);
            $fields["l-t-1-20_bi-unit-cost-$basket_item_count"] = round($order->getShippingAmount(),2)*100;
            $fields["i-t-1-11_bi-unit-count-$basket_item_count"] = 1;
            $fields["l-t-1-20_bi-gross-amount-$basket_item_count"] = 
            round($order->getShippingInclTax(),2)*100;
            $fields["l-t-1-20_bi-net-amount-$basket_item_count"] = $fields["l-t-1-20_bi-unit-cost-$basket_item_count"];
            if ($order->getShippingAmount()>0) {
                $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = round(($order->getShippingInclTax() - $order->getShippingAmount())/$order->getShippingAmount(),2)*100*100;
            } else {
                $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = 0;
            }
            $fields["i-t-1-4_bi-discount-percentage-$basket_item_count"] =  0;
   

            $items_tax +=  (int) $fields["l-t-1-20_bi-gross-amount-$basket_item_count"] - $fields["l-t-1-20_bi-net-amount-$basket_item_count"];
            $items_net_price +=  (int) $fields["l-t-1-20_bi-net-amount-$basket_item_count"];
            $items_gross_price += (int) $fields["l-t-1-20_bi-gross-amount-$basket_item_count"];

  // discount
            $discountAmount =  $order_gross_amount - $items_gross_price;
            if(abs($discountAmount) >= 1 ) { 
                ++$basket_item_count;
                $fields["s-t-1-30_bi-name-$basket_item_count"] = $this->_sanitise($order->getDiscountDescription(),30);
                $fields["i-t-1-11_bi-unit-count-$basket_item_count"] = 1;
                $fields["l-t-1-20_bi-unit-cost-$basket_item_count"] = round($order_net_amount - $items_net_price,0);
                $fields["l-t-1-20_bi-gross-amount-$basket_item_count"] = round($order_gross_amount - $items_gross_price,0);
                $fields["l-t-1-20_bi-net-amount-$basket_item_count"] = round($order_net_amount - $items_net_price,0);
                if($fields["l-t-1-20_bi-net-amount-$basket_item_count"] != 0) { 
                    $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = round(($fields["l-t-1-20_bi-gross-amount-$basket_item_count"]  - $fields["l-t-1-20_bi-net-amount-$basket_item_count"]) / $fields["l-t-1-20_bi-net-amount-$basket_item_count"],2) * 100 * 100; 
                } else {
                    $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = 0;
                }
                if(abs($fields["i-t-1-4_bi-vat-percentage-$basket_item_count"]) > 10000) {
                    // could be absurd numbers due to rounding errors
                    $fields["i-t-1-4_bi-vat-percentage-$basket_item_count"] = 0;
                }
     
                $fields["i-t-1-4_bi-discount-percentage-$basket_item_count"] = 0;
            }
        }

        if($this->getConfigData('skip_confirmation_page') == 1) {
            $fields["i-t-1-1_skip-confirmation-page"] = "1";
        }


        $cryptutils = Mage::helper('PointPayment/cryptutils');
        $fields["s-t-256-256_signature-one"] = 
        $cryptutils->generatesignature($cryptutils->formatparameters($fields));
        return $fields;
    }

    // prepare data to be used for POST
    protected function _sanitise($data, $maxlen, $reverse=false)
    {
        $data = str_replace('"','',str_replace('\\','',$data));
        if(!$reverse) {
            return substr($data,0,$maxlen);
        } else {
            return substr($data, 0 - $maxlen);
        }
    }

  protected function _convert_country_code_to_numeric($cc)
  {
      $codes = array(
'AF' =>     4,          
'AL' =>     8,          
'DZ' =>    12,          
'AS' =>    16,          
'AD' =>    20,          
'AO' =>    24,          
'AI' =>   660,          
'AQ' =>    10,          
'AG' =>    28,          
'AR' =>    32,          
'AM' =>    51,          
'AW' =>   533,          
'AU' =>    36,          
'AT' =>    40,          
'AZ' =>    31,          
'BS' =>    44,          
'BH' =>    48,          
'BD' =>    50,          
'BB' =>    52,          
'BY' =>   112,          
'BE' =>    56,          
'BZ' =>    84,          
'BJ' =>   204,          
'BM' =>    60,          
'BT' =>    64,          
'BO' =>    68,          
'BA' =>    70,          
'BW' =>    72,          
'BV' =>    74,          
'BR' =>    76,          
'IO' =>    86,          
'BN' =>    96,          
'BG' =>   100,          
'BF' =>   854,          
'BI' =>   108,          
'KH' =>   116,          
'CM' =>   120,          
'CA' =>   124,          
'CV' =>   132,          
'KY' =>   136,          
'CF' =>   140,          
'TD' =>   148,          
'CL' =>   152,          
'CN' =>   156,          
'CX' =>   162,          
'CC' =>   166,          
'CO' =>   170,          
'KM' =>   174,          
'CG' =>   178,          
'CK' =>   184,          
'CR' =>   188,          
'CI' =>   384,          
'HR' =>   191,          
'CU' =>   192,          
'CY' =>   196,          
'CZ' =>   203,          
'DK' =>   208,          
'DJ' =>   262,          
'DM' =>   212,          
'DO' =>   214,          
'TP' =>   626,          
'EC' =>   218,          
'EG' =>   818,          
'SV' =>   222,          
'GQ' =>   226,          
'ER' =>   232,          
'EE' =>   233,          
'ET' =>   231,          
'FK' =>   238,          
'FO' =>   234,          
'FJ' =>   242,          
'FI' =>   246,          
'FR' =>   250,          
'FX' =>   249,          
'GF' =>   254,          
'PF' =>   258,          
'TF' =>   260,          
'GA' =>   266,          
'GM' =>   270,          
'GE' =>   268,          
'DE' =>   276,          
'GH' =>   288,          
'GI' =>   292,          
'GR' =>   300,          
'GL' =>   304,          
'GD' =>   308,          
'GP' =>   312,          
'GU' =>   316,          
'GT' =>   320,          
'GN' =>   324,          
'GW' =>   624,          
'GY' =>   328,          
'HT' =>   332,          
'HM' =>   334,          
'VA' =>   336,          
'HN' =>   340,          
'HK' =>   344,          
'HU' =>   348,          
'IS' =>   352,          
'IN' =>   356,          
'ID' =>   360,          
'IR' =>   364,          
'IQ' =>   368,          
'IE' =>   372,          
'IL' =>   376,          
'IT' =>   380,          
'JM' =>   388,          
'JP' =>   392,          
'JO' =>   400,          
'KZ' =>   398,          
'KE' =>   404,          
'KI' =>   296,          
'KP' =>   408,          
'KR' =>   410,          
'KW' =>   414,          
'KG' =>   417,          
'LA' =>   418,          
'LV' =>   428,          
'LB' =>   422,          
'LS' =>   426,          
'LR' =>   430,          
'LY' =>   434,          
'LI' =>   438,          
'LT' =>   440,          
'LU' =>   442,          
'MO' =>   446,          
'MK' =>   807,          
'MG' =>   450,          
'MW' =>   454,          
'MY' =>   458,          
'MV' =>   462,          
'ML' =>   466,          
'MT' =>   470,          
'MH' =>   584,          
'MQ' =>   474,          
'MR' =>   478,          
'MU' =>   480,          
'YT' =>   175,          
'MX' =>   484,          
'FM' =>   583,          
'MD' =>   498,          
'MC' =>   492,          
'MN' =>   496,          
'MS' =>   500,          
'MA' =>   504,          
'MZ' =>   508,          
'MM' =>   104,          
'NA' =>   516,          
'NR' =>   520,          
'NP' =>   524,          
'NL' =>   528,          
'AN' =>   530,          
'NC' =>   540,          
'NZ' =>   554,          
'NI' =>   558,          
'NE' =>   562,          
'NG' =>   566,          
'NU' =>   570,          
'NF' =>   574,          
'MP' =>   580,          
'NO' =>   578,          
'OM' =>   512,          
'PK' =>   586,          
'PW' =>   585,          
'PA' =>   591,          
'PG' =>   598,          
'PY' =>   600,          
'PE' =>   604,          
'PH' =>   608,          
'PN' =>   612,          
'PL' =>   616,          
'PT' =>   620,          
'PR' =>   630,          
'QA' =>   634,          
'RE' =>   638,          
'RO' =>   642,          
'RU' =>   643,          
'RW' =>   646,          
'KN' =>   659,          
'LC' =>   662,          
'VC' =>   670,          
'WS' =>   882,          
'SM' =>   674,          
'ST' =>   678,          
'SA' =>   682,          
'SN' =>   686,          
'SC' =>   690,          
'SL' =>   694,          
'SG' =>   702,          
'SK' =>   703,          
'SI' =>   705,          
'SB' =>    90,          
'SO' =>   706,          
'ZA' =>   710,          
'GS' =>   239,          
'ES' =>   724,          
'LK' =>   144,          
'SH' =>   654,          
'PM' =>   666,          
'SD' =>   736,          
'SR' =>   740,          
'SJ' =>   744,          
'SZ' =>   748,          
'SE' =>   752,          
'CH' =>   756,          
'SY' =>   760,          
'TW' =>   158,          
'TJ' =>   762,          
'TZ' =>   834,          
'TH' =>   764,          
'TG' =>   768,          
'TK' =>   772,          
'TO' =>   776,          
'TT' =>   780,          
'TN' =>   788,          
'TR' =>   792,          
'TM' =>   795,          
'TC' =>   796,          
'TV' =>   798,          
'UG' =>   800,          
'UA' =>   804,          
'AE' =>   784,          
'GB' =>   826,          
'US' =>   840,          
'UM' =>   581,          
'UY' =>   858,          
'UZ' =>   860,          
'VU' =>   548,          
'VE' =>   862,          
'VN' =>   704,          
'VG' =>    92,          
'VI' =>   850,          
'WF' =>   876,          
'EH' =>   732,          
'YE' =>   887,          
'YU' =>   891,          
'ZR' =>   180,          
'ZM' =>   894,          
'ZW' =>   716);

        if(isset($codes[$cc])) {
            return $codes[$cc];
        } else {
            return "246";  // default to Finland
        }
    }

}
