﻿using System;
using System.Collections;

/// <summary>
/// Custom String sorter to work around .NET sort bug which ignores special
/// characters like '-'.
/// </summary>
public class VerifoneStringComparer : IComparer
{
    /** The sort order. */
    private String SORT_ORDER = "0123456789-#_abcdefghijklmnopqrstuvwxyz";

    public int Compare(object x, object y)
    {
        if ((x is String) && (y is String))
        {
            String xx = ((String)x).Replace("-", "#");
            String yy = ((String)y).Replace("-", "#");

            for (int i = 0; i < xx.Length; i++)
            {
                if (i >= yy.Length)
                {
                    return xx.CompareTo(yy);
                }

                int xIndex = SORT_ORDER.IndexOf(xx[i]);
                int yIndex = SORT_ORDER.IndexOf(yy[i]);

                if (xIndex == -1 && yIndex != -1)
                {
                    return 1;
                }
                else if (xIndex != -1 && yIndex == -1)
                {
                    return -1;
                }
                else if (xIndex < yIndex)
                {
                    return -1;
                }
                else if (xIndex > yIndex)
                {
                    return 1;
                }
            }
            return ((String)xx).CompareTo(yy);
        }
        return -1;
    }
}