﻿using Org.BouncyCastle.Crypto;
using System;

/// <summary>
/// Utility class for loading private and public keys from pem files
/// </summary>
public class VerifoneKeyLoader
{
    /// <summary>
    /// Load AsymmetricKeyParameter containing the public key in the string path
    /// </summary>
    /// <param name="path"></param>
    /// <returns>The AsymmetricKeyParameter loaded from path</returns>
    public static AsymmetricKeyParameter LoadPublicKey(String path)
    {
        System.IO.StreamReader fileStream = System.IO.File.OpenText(path);
        Org.BouncyCastle.OpenSsl.PemReader pemReader = new Org.BouncyCastle.OpenSsl.PemReader(fileStream);
        AsymmetricKeyParameter KeyParameter = (AsymmetricKeyParameter)pemReader.ReadObject();

        return KeyParameter;
    }

    /// <summary>
    /// Load AsymmetricCipherKeyPair containing the private key in the string path
    /// </summary>
    /// <param name="path"></param>
    /// <returns>The AsymmetricCipherKeyPair loaded from path</returns>
    public static AsymmetricCipherKeyPair LoadPrivateKey(String path)
    {
        System.IO.StreamReader fileStream = System.IO.File.OpenText(path);
        Org.BouncyCastle.OpenSsl.PemReader pemReader = new Org.BouncyCastle.OpenSsl.PemReader(fileStream);
        AsymmetricCipherKeyPair KeyParameter = (AsymmetricCipherKeyPair)pemReader.ReadObject();

        return KeyParameter;
    }
}