﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using Org.BouncyCastle.Crypto;

public partial class order : System.Web.UI.Page
{
    private const String PAYMENT_SITE_URL = "https://epayment.test.point.fi/pw/payment";
    private const String SHOP_SITE_URL = "http://localhost:64909";
    private const String MERCHANT_AGREEMENT_CODE = "demo-merchant-se";
    private const String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private AsymmetricCipherKeyPair privateKeyPair;

    public order()
    {
        privateKeyPair = VerifoneKeyLoader.LoadPrivateKey("keys/demo-merchant-agreement-private.pem");
    }

    protected override void Render(HtmlTextWriter writer)
    {
        SortedDictionary<String, String> parameters = new SortedDictionary<String, String>();
        DateTime now = DateTime.Now.ToUniversalTime();

        parameters.Add("locale-f-2-5_payment-locale", "en_GB");
        parameters.Add("t-f-14-19_payment-timestamp", now.ToString(DATE_FORMAT));
        parameters.Add("s-f-1-36_merchant-agreement-code", MERCHANT_AGREEMENT_CODE);
        parameters.Add("s-f-1-36_order-number", now.Ticks.ToString());
        parameters.Add("t-f-14-19_order-timestamp", now.ToString(DATE_FORMAT));
        parameters.Add("s-t-1-36_order-note", "x213");
        parameters.Add("i-f-1-3_order-currency-code", "752");
        parameters.Add("l-f-1-20_order-net-amount", "1000");
        parameters.Add("l-f-1-20_order-gross-amount", "1250");
        parameters.Add("l-f-1-20_order-vat-amount", "250");
        parameters.Add("i-t-1-4_order-vat-percentage", "2500");
        parameters.Add("s-f-1-30_buyer-first-name", "Jane");
        parameters.Add("s-f-1-30_buyer-last-name", "Doe");
        parameters.Add("s-t-1-30_buyer-phone-number", "+358 50 234234");
        parameters.Add("s-f-1-100_buyer-email-address", "jane.doe@example.com");
        parameters.Add("s-t-1-30_delivery-address-line-one", "Street Address #1");
        parameters.Add("s-t-1-30_delivery-address-line-two", "Street Address #2");
        parameters.Add("s-t-1-30_delivery-address-line-three", "Street Address #3");
        parameters.Add("s-t-1-30_delivery-address-city", "City");
        parameters.Add("s-t-1-30_delivery-address-postal-code", "00234");
        parameters.Add("i-t-1-3_delivery-address-country-code", "246");

        parameters.Add("s-t-1-30_payment-method-code", "");
        parameters.Add("l-t-1-20_saved-payment-method-id", "");
        parameters.Add("s-t-1-30_style-code", "");
        parameters.Add("i-t-1-1_recurring-payment", "0");
        parameters.Add("i-t-1-1_deferred-payment", "0");
        parameters.Add("i-t-1-1_save-payment-method", "0");
        parameters.Add("i-t-1-1_skip-confirmation-page", "0");

        parameters.Add("s-f-5-256_success-url", SHOP_SITE_URL + "/receipt.aspx");
        parameters.Add("s-f-5-256_rejected-url", SHOP_SITE_URL + "/cancel.aspx");
        parameters.Add("s-f-5-256_cancel-url", SHOP_SITE_URL + "/cancel.aspx");
        parameters.Add("s-f-5-256_expired-url", SHOP_SITE_URL + "/cancel.aspx");
        parameters.Add("s-f-5-256_error-url", SHOP_SITE_URL + "/cancel.aspx");

        parameters.Add("s-t-1-30_bi-name-0", "test-basket-item-0");
        parameters.Add("l-t-1-20_bi-unit-cost-0", "1000");
        parameters.Add("i-t-1-11_bi-unit-count-0", "1");
        parameters.Add("l-t-1-20_bi-net-amount-0", "1000");
        parameters.Add("l-t-1-20_bi-gross-amount-0", "1250");
        parameters.Add("i-t-1-4_bi-vat-percentage-0", "2500");
        parameters.Add("i-t-1-4_bi-discount-percentage-0", "0");

        parameters.Add("s-f-1-30_software", "Demo Web Shop");
        parameters.Add("s-f-1-10_software-version", "1.0.0");
        parameters.Add("i-f-1-11_interface-version", "5");

        String paymentToken = VerifoneSignatureUtil.CreatePaymentToken(parameters);
        parameters.Add("s-f-32-32_payment-token", paymentToken);

        String content = VerifoneSignatureUtil.FormatParameters(parameters);
        String signatureOne = VerifoneSignatureUtil.CreateSignature(privateKeyPair, content, HashAlgorithm.SHA1);
        parameters.Add("s-t-256-256_signature-one", signatureOne);

        writer.WriteLine("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.WriteLine("<html>");
        writer.WriteLine("<head>");
        writer.WriteLine("<title>");
        writer.WriteLine("Demo Order Page");
        writer.WriteLine("</title>");
        writer.WriteLine("</head>");
        writer.WriteLine("<body>");
        writer.WriteLine("<form id=\"integration-form\" action=\"" + PAYMENT_SITE_URL + "\" method=\"post\">");
        writer.WriteLine("<h1>Test Shop Order</h1>");
        writer.WriteLine("<table>");

        foreach (KeyValuePair<string, string> kvp in parameters)
        {
            writer.WriteLine("<tr><td>" + kvp.Key + "</td><td><input readonly type=\"text\" name=\"" + kvp.Key + "\" value=\"" + kvp.Value + "\" /></td></tr>");
        }

        writer.WriteLine("</table>");
        writer.WriteLine("<input type=\"submit\" name=\"s-t-1-40_submit\" value=\"Submit\" />");
        writer.WriteLine("</form>");
        writer.WriteLine("</body>");
        writer.WriteLine("</html>");
    }
}