package com.verifone.demo_shop;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

/**
 * Servlet configuration listener.
 */
public class DemoShopServletContextListener implements ServletContextListener {

	private static final String PAYMENT_SITE_URL = "https://epayment.test.point.fi/pw/payment";
	private static final String SHOP_SITE_URL = "http://127.0.0.1:8080/demo-shop/";

	private static final String MERCHANT_AGREEMENT_CODE = "demo-merchant-se";

	private static final String SHOP_PRIVATE_KEY = "demo-merchant-agreement-private.pem";
	private static final String VERIFONE_PUBLIC_KEY = "verifone-e-commerce-test-public-key.pem";

	private PrivateKey shopPrivateKey;
	private PublicKey paymentPagePublicKey;

	/**
	 * Constructor for setting up environment.
	 */
	public DemoShopServletContextListener() {
		super();

		Security.addProvider(new BouncyCastleProvider());

		try {
			shopPrivateKey = getPrivateKeyFromString(loadString(SHOP_PRIVATE_KEY));;
			paymentPagePublicKey = getPublicKeyFromString(loadString(VERIFONE_PUBLIC_KEY));
		} catch (Exception e) {
			throw new RuntimeException("Failed to configure environment", e);
		}
	}

	@Override
	public final void contextInitialized(final ServletContextEvent sce) {
		sce.getServletContext().setAttribute("shop-private-key", shopPrivateKey);
		sce.getServletContext().setAttribute("payment-page-public-key", paymentPagePublicKey);
		sce.getServletContext().setAttribute("payment-page-url", PAYMENT_SITE_URL);
		sce.getServletContext().setAttribute("shop-url", SHOP_SITE_URL);
		sce.getServletContext().setAttribute("merchant-agreement-code", MERCHANT_AGREEMENT_CODE);
	}

	@Override
	public void contextDestroyed(final ServletContextEvent sce) {}

	private String loadString(final String fileName) {
		final StringBuilder builder = new StringBuilder();
		InputStream inputStream = null;
		try {
			inputStream = getClass().getResourceAsStream("/" + fileName);

			final BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
			final String newLine = System.getProperty("line.separator");
			String line;
			while ((line = reader.readLine()) != null) {
				builder.append(line);
				builder.append(newLine);
			}

			return builder.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		} finally {
			if (inputStream != null) {
				try {
					inputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	private static PrivateKey getPrivateKeyFromString(final String key) {
		String privateKeyPEM = key;
		privateKeyPEM = privateKeyPEM.replace("-----BEGIN RSA PRIVATE KEY-----", "");
		privateKeyPEM = privateKeyPEM.replace("-----END RSA PRIVATE KEY-----", "").trim();

		try {
			final byte[] encoded = Base64.decode(privateKeyPEM);
			final KeyFactory kf = KeyFactory.getInstance("RSA");
			final PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
			final PrivateKey privateKey = kf.generatePrivate(keySpec);
			return privateKey;
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
			return null;
		} catch (InvalidKeySpecException e) {
			e.printStackTrace();
			return null;
		}
	}

	private static PublicKey getPublicKeyFromString(final String key) {
		String publicKeyPEM = key;
		publicKeyPEM = publicKeyPEM.replace("-----BEGIN PUBLIC KEY-----", "");
		publicKeyPEM = publicKeyPEM.replace("-----END PUBLIC KEY-----", "").trim();

		try {
			final byte[] encoded = Base64.decode(publicKeyPEM);
			final X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encoded);
			final KeyFactory keyFactory = KeyFactory.getInstance("RSA");
			return keyFactory.generatePublic(pubKeySpec);
		} catch (InvalidKeySpecException e) {
			e.printStackTrace();
			return null;
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
			return null;
		}
	}
}
