/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;

public class KeyBasedLargeFileProcessor {
    private static PGPPublicKey readPublicKey(InputStream inputStream) throws IOException, PGPException {
        inputStream = PGPUtil.getDecoderStream(inputStream);
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(inputStream);
        PGPPublicKey pGPPublicKey = null;
        Iterator iterator = pGPPublicKeyRingCollection.getKeyRings();
        while (pGPPublicKey == null && iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)iterator.next();
            Iterator iterator2 = pGPPublicKeyRing.getPublicKeys();
            while (pGPPublicKey == null && iterator2.hasNext()) {
                PGPPublicKey pGPPublicKey2 = (PGPPublicKey)iterator2.next();
                if (!pGPPublicKey2.isEncryptionKey()) continue;
                pGPPublicKey = pGPPublicKey2;
            }
        }
        if (pGPPublicKey == null) {
            throw new IllegalArgumentException("Can't find encryption key in key ring.");
        }
        return pGPPublicKey;
    }

    private static PGPPrivateKey findSecretKey(PGPSecretKeyRingCollection pGPSecretKeyRingCollection, long l, char[] cArray) throws PGPException, NoSuchProviderException {
        PGPSecretKey pGPSecretKey = pGPSecretKeyRingCollection.getSecretKey(l);
        if (pGPSecretKey == null) {
            return null;
        }
        return pGPSecretKey.extractPrivateKey(cArray, "BC");
    }

    private static void decryptFile(InputStream inputStream, InputStream inputStream2, char[] cArray, String string) throws Exception {
        block13: {
            inputStream = PGPUtil.getDecoderStream(inputStream);
            try {
                BufferedOutputStream bufferedOutputStream;
                PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
                Object object = pGPObjectFactory.nextObject();
                PGPEncryptedDataList pGPEncryptedDataList = object instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object : (PGPEncryptedDataList)pGPObjectFactory.nextObject();
                Iterator iterator = pGPEncryptedDataList.getEncryptedDataObjects();
                PGPPrivateKey pGPPrivateKey = null;
                PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = null;
                PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(inputStream2));
                while (pGPPrivateKey == null && iterator.hasNext()) {
                    pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)iterator.next();
                    pGPPrivateKey = KeyBasedLargeFileProcessor.findSecretKey(pGPSecretKeyRingCollection, pGPPublicKeyEncryptedData.getKeyID(), cArray);
                }
                if (pGPPrivateKey == null) {
                    throw new IllegalArgumentException("secret key for message not found.");
                }
                InputStream inputStream3 = pGPPublicKeyEncryptedData.getDataStream(pGPPrivateKey, "BC");
                PGPObjectFactory pGPObjectFactory2 = new PGPObjectFactory(inputStream3);
                PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory2.nextObject();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(pGPCompressedData.getDataStream());
                PGPObjectFactory pGPObjectFactory3 = new PGPObjectFactory(bufferedInputStream);
                Object object2 = pGPObjectFactory3.nextObject();
                if (object2 instanceof PGPLiteralData) {
                    int n;
                    PGPLiteralData pGPLiteralData = (PGPLiteralData)object2;
                    String string2 = pGPLiteralData.getFileName();
                    if (string2.length() == 0) {
                        string2 = string;
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(string2);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    InputStream inputStream4 = pGPLiteralData.getInputStream();
                    while ((n = inputStream4.read()) >= 0) {
                        bufferedOutputStream.write(n);
                    }
                } else {
                    if (object2 instanceof PGPOnePassSignatureList) {
                        throw new PGPException("encrypted message contains a signed message - not literal data.");
                    }
                    throw new PGPException("message is not a simple encrypted file - type unknown.");
                }
                bufferedOutputStream.close();
                if (pGPPublicKeyEncryptedData.isIntegrityProtected()) {
                    if (!pGPPublicKeyEncryptedData.verify()) {
                        System.err.println("message failed integrity check");
                    } else {
                        System.err.println("message integrity check passed");
                    }
                } else {
                    System.err.println("no message integrity check");
                }
            }
            catch (PGPException pGPException) {
                System.err.println(pGPException);
                if (pGPException.getUnderlyingException() == null) break block13;
                pGPException.getUnderlyingException().printStackTrace();
            }
        }
    }

    private static void encryptFile(OutputStream outputStream, String string, PGPPublicKey pGPPublicKey, boolean bl, boolean bl2) throws IOException, NoSuchProviderException {
        block3: {
            if (bl) {
                outputStream = new ArmoredOutputStream(outputStream);
            }
            try {
                PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(3, bl2, new SecureRandom(), "BC");
                pGPEncryptedDataGenerator.addMethod(pGPPublicKey);
                OutputStream outputStream2 = pGPEncryptedDataGenerator.open(outputStream, new byte[65536]);
                PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
                PGPUtil.writeFileToLiteralData(pGPCompressedDataGenerator.open(outputStream2), 'b', new File(string), new byte[65536]);
                pGPCompressedDataGenerator.close();
                outputStream2.close();
                outputStream.close();
            }
            catch (PGPException pGPException) {
                System.err.println(pGPException);
                if (pGPException.getUnderlyingException() == null) break block3;
                pGPException.getUnderlyingException().printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray.length == 0) {
            System.err.println("usage: KeyBasedLargeFileProcessor -e|-d [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
            return;
        }
        if (stringArray[0].equals("-e")) {
            if (stringArray[1].equals("-a") || stringArray[1].equals("-ai") || stringArray[1].equals("-ia")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2] + ".asc");
                KeyBasedLargeFileProcessor.encryptFile(fileOutputStream, stringArray[2], KeyBasedLargeFileProcessor.readPublicKey(fileInputStream), true, stringArray[1].indexOf(105) > 0);
            } else if (stringArray[1].equals("-i")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2] + ".bpg");
                KeyBasedLargeFileProcessor.encryptFile(fileOutputStream, stringArray[2], KeyBasedLargeFileProcessor.readPublicKey(fileInputStream), false, true);
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1] + ".bpg");
                KeyBasedLargeFileProcessor.encryptFile(fileOutputStream, stringArray[1], KeyBasedLargeFileProcessor.readPublicKey(fileInputStream), false, false);
            }
        } else if (stringArray[0].equals("-d")) {
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            FileInputStream fileInputStream2 = new FileInputStream(stringArray[2]);
            KeyBasedLargeFileProcessor.decryptFile(fileInputStream, fileInputStream2, stringArray[3].toCharArray(), new File(stringArray[1]).getName() + ".out");
        } else {
            System.err.println("usage: KeyBasedLargeFileProcessor -d|-e [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
        }
    }
}

