/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;

public class DirectKeySignature {
    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray.length == 1) {
            PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new FileInputStream(stringArray[0])));
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey();
            Iterator iterator = pGPPublicKey.getSignaturesOfType(31);
            while (iterator.hasNext()) {
                PGPSignature pGPSignature = (PGPSignature)iterator.next();
                System.out.println("Signature date is: " + pGPSignature.getHashedSubPackets().getSignatureCreationTime());
                NotationData[] notationDataArray = pGPSignature.getHashedSubPackets().getNotationDataOccurences();
                for (int i = 0; i < notationDataArray.length; ++i) {
                    System.out.println("Found Notaion named '" + notationDataArray[i].getNotationName() + "' with content '" + notationDataArray[i].getNotationValue() + "'.");
                }
            }
        } else if (stringArray.length == 5) {
            PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(PGPUtil.getDecoderStream(new FileInputStream(stringArray[0])));
            String string = stringArray[1];
            PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new FileInputStream(stringArray[2])));
            String string2 = stringArray[3];
            String string3 = stringArray[4];
            PGPPublicKeyRing pGPPublicKeyRing2 = null;
            pGPPublicKeyRing = pGPPublicKeyRing2 = new PGPPublicKeyRing(new ByteArrayInputStream(DirectKeySignature.signPublicKey(pGPSecretKeyRing.getSecretKey(), string, pGPPublicKeyRing.getPublicKey(), string2, string3, true)));
            ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(new FileOutputStream("SignedKey.asc"));
            pGPPublicKeyRing2.encode(armoredOutputStream);
            armoredOutputStream.flush();
            armoredOutputStream.close();
        } else {
            System.err.println("usage: DirectKeySignature secretKeyFile secretKeyPass publicKeyFile(key to be signed) NotationName NotationValue");
            System.err.println("or: DirectKeySignature signedPublicKeyFile");
        }
    }

    private static byte[] signPublicKey(PGPSecretKey pGPSecretKey, String string, PGPPublicKey pGPPublicKey, String string2, String string3, boolean bl) throws Exception {
        OutputStream outputStream = new ByteArrayOutputStream();
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(string.toCharArray(), "BC");
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), 2, "BC");
        pGPSignatureGenerator.initSign(31, pGPPrivateKey);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(outputStream);
        pGPSignatureGenerator.generateOnePassVersion(false).encode(bCPGOutputStream);
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        boolean bl2 = true;
        pGPSignatureSubpacketGenerator.setNotationData(true, bl2, string2, string3);
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignatureSubpacketGenerator.generate();
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
        bCPGOutputStream.flush();
        return PGPPublicKey.addCertification(pGPPublicKey, pGPSignatureGenerator.generate()).getEncoded();
    }
}

