/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.SignatureException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;

public class DetachedSignatureProcessor {
    private static PGPSecretKey readSecretKey(InputStream inputStream) throws IOException, PGPException {
        inputStream = PGPUtil.getDecoderStream(inputStream);
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(inputStream);
        PGPSecretKey pGPSecretKey = null;
        Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
        while (pGPSecretKey == null && iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
            while (pGPSecretKey == null && iterator2.hasNext()) {
                PGPSecretKey pGPSecretKey2 = (PGPSecretKey)iterator2.next();
                if (!pGPSecretKey2.isSigningKey()) continue;
                pGPSecretKey = pGPSecretKey2;
            }
        }
        if (pGPSecretKey == null) {
            throw new IllegalArgumentException("Can't find encryption key in key ring.");
        }
        return pGPSecretKey;
    }

    private static void verifySignature(String string, InputStream inputStream, InputStream inputStream2) throws Exception {
        int n;
        Object object;
        inputStream = PGPUtil.getDecoderStream(inputStream);
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        PGPSignatureList pGPSignatureList = null;
        Object object2 = pGPObjectFactory.nextObject();
        if (object2 instanceof PGPCompressedData) {
            object = (PGPCompressedData)object2;
            pGPObjectFactory = new PGPObjectFactory(((PGPCompressedData)object).getDataStream());
            pGPSignatureList = (PGPSignatureList)pGPObjectFactory.nextObject();
        } else {
            pGPSignatureList = (PGPSignatureList)object2;
        }
        object = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(inputStream2));
        FileInputStream fileInputStream = new FileInputStream(string);
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        PGPPublicKey pGPPublicKey = ((PGPPublicKeyRingCollection)object).getPublicKey(pGPSignature.getKeyID());
        pGPSignature.initVerify(pGPPublicKey, "BC");
        while ((n = ((InputStream)fileInputStream).read()) >= 0) {
            pGPSignature.update((byte)n);
        }
        if (pGPSignature.verify()) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static void createSignature(String string, InputStream inputStream, OutputStream outputStream, char[] cArray, boolean bl) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPSecretKey pGPSecretKey = DetachedSignatureProcessor.readSecretKey(inputStream);
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(cArray, "BC");
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), 2, "BC");
        pGPSignatureGenerator.initSign(0, pGPPrivateKey);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(outputStream);
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = 0;
        while ((n = fileInputStream.read()) >= 0) {
            pGPSignatureGenerator.update((byte)n);
        }
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        outputStream.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray[0].equals("-s")) {
            if (stringArray[1].equals("-a")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2] + ".asc");
                DetachedSignatureProcessor.createSignature(stringArray[2], fileInputStream, fileOutputStream, stringArray[4].toCharArray(), true);
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1] + ".bpg");
                DetachedSignatureProcessor.createSignature(stringArray[1], fileInputStream, fileOutputStream, stringArray[3].toCharArray(), false);
            }
        } else if (stringArray[0].equals("-v")) {
            FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
            FileInputStream fileInputStream2 = new FileInputStream(stringArray[3]);
            DetachedSignatureProcessor.verifySignature(stringArray[1], fileInputStream, fileInputStream2);
        } else {
            System.err.println("usage: DetachedSignatureProcessor [-s [-a] file keyfile passPhrase]|[-v file sigFile keyFile]");
        }
    }
}

