/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.SignatureException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;

public class ClearSignedFileProcessor {
    private static PGPSecretKey readSecretKey(InputStream inputStream) throws IOException, PGPException {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(inputStream);
        PGPSecretKey pGPSecretKey = null;
        Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
        while (pGPSecretKey == null && iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
            while (pGPSecretKey == null && iterator2.hasNext()) {
                PGPSecretKey pGPSecretKey2 = (PGPSecretKey)iterator2.next();
                if (!pGPSecretKey2.isSigningKey()) continue;
                pGPSecretKey = pGPSecretKey2;
            }
        }
        if (pGPSecretKey == null) {
            throw new IllegalArgumentException("Can't find signing key in key ring.");
        }
        return pGPSecretKey;
    }

    private static int readInputLine(ByteArrayOutputStream byteArrayOutputStream, InputStream inputStream) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        int n2 = -1;
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
            if (n != 13 && n != 10) continue;
            n2 = ClearSignedFileProcessor.readPassedEOL(byteArrayOutputStream, n, inputStream);
            break;
        }
        return n2;
    }

    private static int readInputLine(ByteArrayOutputStream byteArrayOutputStream, int n, InputStream inputStream) throws IOException {
        byteArrayOutputStream.reset();
        int n2 = n;
        do {
            byteArrayOutputStream.write(n2);
            if (n2 != 13 && n2 != 10) continue;
            n = ClearSignedFileProcessor.readPassedEOL(byteArrayOutputStream, n2, inputStream);
            break;
        } while ((n2 = inputStream.read()) >= 0);
        if (n2 < 0) {
            n = -1;
        }
        return n;
    }

    private static int readPassedEOL(ByteArrayOutputStream byteArrayOutputStream, int n, InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n == 13 && n2 == 10) {
            byteArrayOutputStream.write(n2);
            n2 = inputStream.read();
        }
        return n2;
    }

    private static void verifyFile(InputStream inputStream, InputStream inputStream2, String string) throws Exception {
        Object object;
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = ClearSignedFileProcessor.readInputLine(byteArrayOutputStream, armoredInputStream);
        byte[] byArray = ClearSignedFileProcessor.getLineSeparator();
        if (n != -1 && armoredInputStream.isClearText()) {
            object = byteArrayOutputStream.toByteArray();
            ((OutputStream)bufferedOutputStream).write((byte[])object, 0, ClearSignedFileProcessor.getLengthWithoutSeparator(object));
            ((OutputStream)bufferedOutputStream).write(byArray);
            while (n != -1 && armoredInputStream.isClearText()) {
                n = ClearSignedFileProcessor.readInputLine(byteArrayOutputStream, n, armoredInputStream);
                object = byteArrayOutputStream.toByteArray();
                ((OutputStream)bufferedOutputStream).write((byte[])object, 0, ClearSignedFileProcessor.getLengthWithoutSeparator(object));
                ((OutputStream)bufferedOutputStream).write(byArray);
            }
        }
        ((OutputStream)bufferedOutputStream).close();
        object = new PGPPublicKeyRingCollection(inputStream2);
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(armoredInputStream);
        PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory.nextObject();
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        pGPSignature.initVerify(object.getPublicKey(pGPSignature.getKeyID()), "BC");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        n = ClearSignedFileProcessor.readInputLine(byteArrayOutputStream, bufferedInputStream);
        ClearSignedFileProcessor.processLine(pGPSignature, byteArrayOutputStream.toByteArray());
        if (n != -1) {
            do {
                n = ClearSignedFileProcessor.readInputLine(byteArrayOutputStream, n, bufferedInputStream);
                pGPSignature.update((byte)13);
                pGPSignature.update((byte)10);
                ClearSignedFileProcessor.processLine(pGPSignature, byteArrayOutputStream.toByteArray());
            } while (n != -1);
        }
        if (pGPSignature.verify()) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static byte[] getLineSeparator() {
        String string = System.getProperty("line.separator");
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    private static void signFile(String string, InputStream inputStream, OutputStream outputStream, char[] cArray, String string2) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        int n = string2.equals("SHA256") ? 8 : (string2.equals("SHA384") ? 9 : (string2.equals("SHA512") ? 10 : (string2.equals("MD5") ? 1 : (string2.equals("RIPEMD160") ? 3 : 2))));
        PGPSecretKey pGPSecretKey = ClearSignedFileProcessor.readSecretKey(inputStream);
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(cArray, "BC");
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n, "BC");
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureGenerator.initSign(1, pGPPrivateKey);
        Iterator iterator = pGPSecretKey.getPublicKey().getUserIDs();
        if (iterator.hasNext()) {
            pGPSignatureSubpacketGenerator.setSignerUserID(false, (String)iterator.next());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(outputStream);
        armoredOutputStream.beginClearText(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = ClearSignedFileProcessor.readInputLine(byteArrayOutputStream, fileInputStream);
        ClearSignedFileProcessor.processLine(armoredOutputStream, pGPSignatureGenerator, byteArrayOutputStream.toByteArray());
        if (n2 != -1) {
            do {
                n2 = ClearSignedFileProcessor.readInputLine(byteArrayOutputStream, n2, fileInputStream);
                pGPSignatureGenerator.update((byte)13);
                pGPSignatureGenerator.update((byte)10);
                ClearSignedFileProcessor.processLine(armoredOutputStream, pGPSignatureGenerator, byteArrayOutputStream.toByteArray());
            } while (n2 != -1);
        }
        armoredOutputStream.endClearText();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(armoredOutputStream);
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        armoredOutputStream.close();
    }

    private static void processLine(PGPSignature pGPSignature, byte[] byArray) throws SignatureException, IOException {
        int n = ClearSignedFileProcessor.getLengthWithoutWhiteSpace(byArray);
        if (n > 0) {
            pGPSignature.update(byArray, 0, n);
        }
    }

    private static void processLine(OutputStream outputStream, PGPSignatureGenerator pGPSignatureGenerator, byte[] byArray) throws SignatureException, IOException {
        int n = ClearSignedFileProcessor.getLengthWithoutWhiteSpace(byArray);
        if (n > 0) {
            pGPSignatureGenerator.update(byArray, 0, n);
        }
        outputStream.write(byArray, 0, byArray.length);
    }

    private static int getLengthWithoutSeparator(byte[] byArray) {
        int n;
        for (n = byArray.length - 1; n >= 0 && ClearSignedFileProcessor.isLineEnding(byArray[n]); --n) {
        }
        return n + 1;
    }

    private static boolean isLineEnding(byte by) {
        return by == 13 || by == 10;
    }

    private static int getLengthWithoutWhiteSpace(byte[] byArray) {
        int n;
        for (n = byArray.length - 1; n >= 0 && ClearSignedFileProcessor.isWhiteSpace(byArray[n]); --n) {
        }
        return n + 1;
    }

    private static boolean isWhiteSpace(byte by) {
        return by == 13 || by == 10 || by == 9 || by == 32;
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray[0].equals("-s")) {
            InputStream inputStream = PGPUtil.getDecoderStream(new FileInputStream(stringArray[2]));
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1] + ".asc");
            if (stringArray.length == 4) {
                ClearSignedFileProcessor.signFile(stringArray[1], inputStream, fileOutputStream, stringArray[3].toCharArray(), "SHA1");
            } else {
                ClearSignedFileProcessor.signFile(stringArray[1], inputStream, fileOutputStream, stringArray[3].toCharArray(), stringArray[4]);
            }
        } else if (stringArray[0].equals("-v")) {
            if (stringArray[1].indexOf(".asc") < 0) {
                System.err.println("file needs to end in \".asc\"");
                System.exit(1);
            }
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            InputStream inputStream = PGPUtil.getDecoderStream(new FileInputStream(stringArray[2]));
            ClearSignedFileProcessor.verifyFile(fileInputStream, inputStream, stringArray[1].substring(0, stringArray[1].length() - 4));
        } else {
            System.err.println("usage: ClearSignedFileProcessor [-s file keyfile passPhrase]|[-v sigFile keyFile]");
        }
    }
}

