/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;
import org.bouncycastle.util.Strings;

public class PGPLiteralDataGenerator
implements StreamGenerator {
    public static final char BINARY = 'b';
    public static final char TEXT = 't';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = PGPLiteralData.NOW;
    private BCPGOutputStream pkOut;
    private boolean oldFormat = false;

    public PGPLiteralDataGenerator() {
    }

    public PGPLiteralDataGenerator(boolean bl) {
        this.oldFormat = bl;
    }

    private void writeHeader(OutputStream outputStream, char c, String string, long l) throws IOException {
        outputStream.write(c);
        byte[] byArray = Strings.toUTF8ByteArray(string);
        outputStream.write((byte)byArray.length);
        for (int i = 0; i != byArray.length; ++i) {
            outputStream.write(byArray[i]);
        }
        long l2 = l / 1000L;
        outputStream.write((byte)(l2 >> 24));
        outputStream.write((byte)(l2 >> 16));
        outputStream.write((byte)(l2 >> 8));
        outputStream.write((byte)l2);
    }

    public OutputStream open(OutputStream outputStream, char c, String string, long l, Date date) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(outputStream, 11, l + 2L + (long)string.length() + 4L, this.oldFormat);
        this.writeHeader(this.pkOut, c, string, date.getTime());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public OutputStream open(OutputStream outputStream, char c, String string, Date date, byte[] byArray) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(outputStream, 11, byArray);
        this.writeHeader(this.pkOut, c, string, date.getTime());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public OutputStream open(OutputStream outputStream, char c, File file) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(outputStream, 11, file.length() + 2L + (long)file.getName().length() + 4L, this.oldFormat);
        this.writeHeader(this.pkOut, c, file.getName(), file.lastModified());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    @Override
    public void close() throws IOException {
        if (this.pkOut != null) {
            this.pkOut.finish();
            this.pkOut.flush();
            this.pkOut = null;
        }
    }
}

