/*
 * Decompiled with CFR 0.152.
 */
package fi.point.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Scanner;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class KeyPairGenerator {
    private static final String ASYMMETRIC_ALG = "RSA";
    private static final int KEY_SIZE = 1024;
    private static final int CERTIFICATE_VALIDITY_TIME_YEARS = 99;

    public static void main(String[] args) throws IOException {
        KeyPairGenerator generator = new KeyPairGenerator();
        System.out.println("Enter merchant agreement code:");
        String dnName = new Scanner(System.in).next();
        System.out.println("Enter keystore password:");
        String password = new String(System.console().readPassword());
        try {
            System.out.println("Generating key pair...");
            String path = KeyPairGenerator.getCurrentPath();
            generator.saveKeyPair(path, dnName, password);
            System.out.println("Key pair generation succeeded.");
            System.out.println("Keys saved in " + path);
        }
        catch (Exception e) {
            System.err.println("Key pair generation failed.");
            e.printStackTrace();
        }
        System.out.println("Press ENTER to exit");
        System.in.read();
    }

    public final void saveKeyPair(String keyPairPath, String commonName, String password) throws Exception {
        BufferedWriter pemWriter;
        String privateKeyFile;
        KeyPair keys;
        block13: {
            keys = this.generateKeyPair(null, 1024);
            X509Certificate certificate = this.createCertificate(keys, commonName);
            String keystoreFile = String.valueOf(keyPairPath) + "/" + commonName + ".p12";
            String publicKeyFile = String.valueOf(keyPairPath) + "/" + commonName + "-public.pem";
            privateKeyFile = String.valueOf(keyPairPath) + "/" + commonName + "-private.pem";
            char[] keystorePassword = password.toCharArray();
            File ksFile = new File(keystoreFile);
            KeyStore ks = KeyStore.getInstance("pkcs12");
            if (ksFile.exists()) {
                System.out.println("Keystore:");
                System.out.println(keystoreFile);
                System.out.println("Already exists overwrite Y/N?");
                String choice = new Scanner(System.in).next();
                if (choice.equalsIgnoreCase("n")) {
                    throw new RuntimeException("Aborted");
                }
                if (!ksFile.delete()) {
                    System.err.println("Failed to remove existing keystore " + keystoreFile + ".");
                    System.exit(1);
                }
            }
            ks.load(null, keystorePassword);
            KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(keys.getPrivate(), new Certificate[]{certificate});
            ks.setEntry(commonName, privateKeyEntry, new KeyStore.PasswordProtection(keystorePassword));
            FileOutputStream keyStoreOutputStream = new FileOutputStream(ksFile);
            ks.store(keyStoreOutputStream, keystorePassword);
            keyStoreOutputStream.close();
            pemWriter = null;
            try {
                try {
                    pemWriter = new PEMWriter(new FileWriter(publicKeyFile));
                    ((PEMWriter)pemWriter).writeObject(keys.getPublic());
                }
                catch (IOException e) {
                    System.err.println("Failed to write public key.");
                    System.exit(1);
                    pemWriter.close();
                    break block13;
                }
            }
            catch (Throwable throwable) {
                pemWriter.close();
                throw throwable;
            }
            pemWriter.close();
        }
        try {
            try {
                pemWriter = new PEMWriter(new FileWriter(privateKeyFile));
                ((PEMWriter)pemWriter).writeObject(keys.getPrivate());
            }
            catch (IOException e) {
                System.err.println("Failed to write private key.");
                System.exit(1);
                pemWriter.close();
            }
        }
        finally {
            pemWriter.close();
        }
    }

    private KeyPair generateKeyPair(String securityProvider, int asymmetricKeySize) throws Exception {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        java.security.KeyPairGenerator keyPairGen = securityProvider != null ? java.security.KeyPairGenerator.getInstance(ASYMMETRIC_ALG, securityProvider) : java.security.KeyPairGenerator.getInstance(ASYMMETRIC_ALG);
        keyPairGen.initialize(asymmetricKeySize);
        return keyPairGen.generateKeyPair();
    }

    private X509Certificate createCertificate(KeyPair keys, String commonName) throws Exception {
        X509V3CertificateGenerator certificateGenerator = new X509V3CertificateGenerator();
        Calendar calendar = Calendar.getInstance();
        X509Name name = new X509Name("CN=" + commonName);
        certificateGenerator.reset();
        certificateGenerator.setIssuerDN(name);
        calendar.setTimeInMillis(System.currentTimeMillis());
        certificateGenerator.setNotBefore(calendar.getTime());
        calendar.add(1, 99);
        certificateGenerator.setNotAfter(calendar.getTime());
        certificateGenerator.setPublicKey(keys.getPublic());
        certificateGenerator.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certificateGenerator.setSubjectDN(name);
        certificateGenerator.setSignatureAlgorithm("SHA1withRSA");
        return certificateGenerator.generate(keys.getPrivate());
    }

    private static String getCurrentPath() throws Exception {
        String currentPath = KeyPairGenerator.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        int sep = currentPath.lastIndexOf("/");
        return currentPath.substring(0, sep);
    }
}

